/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.xml.registry.common.util.Utility;
import com.sun.xml.registry.uddi.BusinessLifeCycleManagerImpl;
import com.sun.xml.registry.uddi.BusinessQueryManagerImpl;
import com.sun.xml.registry.uddi.CapabilityProfileImpl;
import com.sun.xml.registry.uddi.ConnectionImpl;
import com.sun.xml.registry.uddi.LifeCycleManagerImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import com.sun.xml.registry.uddi.UDDIObjectManager;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Security;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Encoder;
import sun.security.provider.Sun;

public class RegistryServiceImpl
implements RegistryService {
    Log log = LogFactory.getLog((String)"com.sun.xml.registry");
    private BusinessLifeCycleManager businessLCM;
    private BusinessQueryManager businessQM;
    private LifeCycleManager lcm;
    private ConnectionImpl connection;
    private BulkResponse bulkResponse;
    private UDDIMapper uddiMapper;
    private String serviceId;
    private UDDIObjectManager objectManager;
    private HashMap bulkResponses = new HashMap();
    private boolean securitySet = false;
    private HashMap equivalentConcepts = new HashMap();
    private String defaultPostalSchemeId;

    RegistryServiceImpl(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        this.serviceId = Utility.generateUUID();
        this.uddiMapper = new UDDIMapper(this);
        this.objectManager = this.uddiMapper.getObjectManager();
    }

    public UDDIMapper getUDDIMapper() {
        if (this.uddiMapper == null) {
            this.uddiMapper = new UDDIMapper(this);
        }
        return this.uddiMapper;
    }

    String getServiceId() {
        return this.serviceId;
    }

    public UDDIObjectManager getObjectManager() {
        if (this.objectManager == null) {
            this.objectManager = this.uddiMapper.getObjectManager();
        }
        return this.objectManager;
    }

    public CapabilityProfile getCapabilityProfile() throws JAXRException {
        return CapabilityProfileImpl.getInstance();
    }

    public BusinessLifeCycleManager getBusinessLifeCycleManager() throws JAXRException {
        if (this.businessLCM == null) {
            this.businessLCM = new BusinessLifeCycleManagerImpl(this);
        }
        return this.businessLCM;
    }

    public BusinessQueryManager getBusinessQueryManager() throws JAXRException {
        if (this.businessQM == null) {
            this.businessQM = new BusinessQueryManagerImpl(this);
        }
        return this.businessQM;
    }

    public LifeCycleManager getLifeCycleManager() throws JAXRException {
        if (this.lcm == null) {
            this.lcm = new LifeCycleManagerImpl(this);
        }
        return this.lcm;
    }

    public DeclarativeQueryManager getDeclarativeQueryManager() throws JAXRException, UnsupportedCapabilityException {
        throw new UnsupportedCapabilityException();
    }

    public String makeRegistrySpecificRequest(String string) throws JAXRException {
        boolean bl = false;
        try {
            return this.uddiMapper.makeRegistrySpecificRequest(string, bl);
        }
        catch (JAXRException jAXRException) {
            bl = true;
            return this.uddiMapper.makeRegistrySpecificRequest(string, bl);
        }
    }

    void addConceptMapping(String string, String string2) throws JAXRException {
        if (string != null && string2 != null) {
            this.equivalentConcepts.put(string, string2);
        }
    }

    HashMap getEquivalentConcepts() {
        return this.equivalentConcepts;
    }

    void setDefaultPostalScheme() {
        if (this.defaultPostalSchemeId == null) {
            this.defaultPostalSchemeId = this.connection.getDefaultPostalAddressScheme();
        }
    }

    public ClassificationScheme getDefaultPostalScheme() throws JAXRException {
        this.defaultPostalSchemeId = this.connection.getDefaultPostalAddressScheme();
        if (this.defaultPostalSchemeId == null) {
            this.log.debug((Object)" defaultPostalSchemeId is null");
        }
        if (this.uddiMapper == null) {
            this.getUDDIMapper();
        }
        if (this.uddiMapper != null) {
            ClassificationScheme classificationScheme = this.uddiMapper.getClassificationSchemeById(this.defaultPostalSchemeId);
            return classificationScheme;
        }
        return null;
    }

    void storeBulkResponse(BulkResponse bulkResponse) {
        try {
            this.bulkResponses.put(bulkResponse.getRequestId(), bulkResponse);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Storing response with id: " + bulkResponse.getRequestId()));
            }
        }
        catch (JAXRException jAXRException) {
            this.log.fatal((Object)jAXRException);
        }
    }

    public BulkResponse getBulkResponse(String string) throws JAXRException {
        Object v = this.bulkResponses.remove(string);
        if (v == null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryServiceImpl:No_response_exists_for_specified_requestId"));
        }
        return (BulkResponse)v;
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public Node jaxmSend(Document document, boolean bl) throws JAXRException {
        Node node = null;
        try {
            Object object;
            Object object2;
            Element element = document.createElement("soap-env:Envelope");
            element.setAttribute("xmlns:soap-env", "http://schemas.xmlsoap.org/soap/envelope/");
            Element element2 = document.createElement("soap-env:Body");
            Element element3 = document.getDocumentElement();
            document.replaceChild(element, element3);
            element.appendChild(element2);
            element2.appendChild(element3);
            String string = this.getConnection().getHttpProxyHost();
            String string2 = this.getConnection().getHttpProxyPort();
            String string3 = this.getConnection().getProxyUserName();
            String string4 = this.getConnection().getProxyPassword();
            String string5 = this.getConnection().getHttpsProxyHost();
            String string6 = this.getConnection().getHttpsProxyPort();
            if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
                object2 = System.getProperties();
                ((Hashtable)object2).put("http.proxyHost", string);
                ((Hashtable)object2).put("http.proxyPort", string2);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("proxy host = " + string));
                    this.log.debug((Object)("proxy port = " + string2));
                }
            }
            if (string5 != null && !string5.equals("") && string6 != null && !string6.equals("")) {
                object2 = System.getProperties();
                ((Hashtable)object2).put("https.proxyHost", string5);
                ((Hashtable)object2).put("https.proxyPort", string6);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("https proxy host = " + string5));
                    this.log.debug((Object)("https proxy port = " + string6));
                }
            }
            object2 = SOAPConnectionFactory.newInstance();
            SOAPConnection sOAPConnection = object2.createConnection();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage sOAPMessage = messageFactory.createMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            if (string3 != null && string4 != null) {
                object = "Basic " + new BASE64Encoder().encode((string3 + ":" + string4).getBytes());
                sOAPMessage.getMimeHeaders().setHeader("Proxy-Authorization", (String)object);
            }
            object = this.uddiMapper.domNode2StringReader(document);
            StreamSource streamSource = new StreamSource((Reader)object);
            sOAPPart.setContent((Source)streamSource);
            String string7 = null;
            if (bl) {
                if (!this.securitySet) {
                    System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                    Security.addProvider(new Sun());
                    Security.addProvider((java.security.Provider)new Provider());
                    this.securitySet = true;
                }
                string7 = this.connection.getLifeCycleManagerURL();
            } else {
                string7 = this.connection.getQueryManagerURL();
            }
            URL uRL = new URL(string7);
            SOAPMessage sOAPMessage2 = sOAPConnection.call(sOAPMessage, (Object)uRL);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            SOAPPart sOAPPart2 = sOAPMessage2.getSOAPPart();
            Source source = sOAPPart2.getContent();
            DOMResult dOMResult = new DOMResult();
            transformer.transform(source, dOMResult);
            Node node2 = dOMResult.getNode();
            while (node2.getLocalName() == null || !node2.getLocalName().equalsIgnoreCase("envelope")) {
                node2 = node2.getFirstChild();
            }
            Node node3 = node2.getFirstChild();
            while (node3.getLocalName() == null || !node3.getLocalName().equalsIgnoreCase("body")) {
                node3 = node3.getNextSibling();
            }
            node = node3.getFirstChild();
            if (node.getNodeName().equals("#text")) {
                node = node.getNextSibling();
            }
        }
        catch (Exception exception) {
            this.log.debug((Object)exception);
            throw new JAXRException((Throwable)exception);
        }
        return node;
    }

    public Node send(Document document, boolean bl) throws JAXRException {
        boolean bl2 = this.getConnection().useSOAP();
        try {
            String string = System.getProperty("useSOAP");
            if (string != null && string.equalsIgnoreCase("true")) {
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            this.log.debug((Object)("Ignoring error checking for system useSOAP property: " + throwable));
        }
        if (bl2) {
            this.log.debug((Object)"Using soap4j instead of jaxm");
            return this.soapSend(document, bl);
        }
        return this.jaxmSend(document, bl);
    }

    public Node soapSend(Document document, boolean bl) throws JAXRException {
        String string = null;
        String string2 = null;
        String string3 = this.getConnection().getProxyUserName();
        String string4 = this.getConnection().getProxyPassword();
        URL uRL = null;
        String string5 = null;
        Element element = null;
        if (bl) {
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            Security.addProvider((java.security.Provider)new Provider());
            string = this.getConnection().getHttpsProxyHost();
            string2 = this.getConnection().getHttpsProxyPort();
            string5 = this.connection.getLifeCycleManagerURL();
        } else {
            Security.addProvider(new Sun());
            string = this.getConnection().getHttpProxyHost();
            string2 = this.getConnection().getHttpProxyPort();
            string5 = this.connection.getQueryManagerURL();
        }
        try {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3;
            Class[] classArray;
            Object[] objectArray4;
            Class[] classArray2;
            Object object;
            Object object2;
            Object obj = Class.forName("org.apache.soap.transport.http.SOAPHTTPConnection").newInstance();
            if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
                object2 = new Class[]{Class.forName("java.lang.String")};
                object = new Object[]{string};
                obj.getClass().getMethod("setProxyHost", (Class<?>)object2).invoke(obj, object);
                classArray2 = new Class[]{Integer.TYPE};
                objectArray4 = new Object[]{new Integer(string2)};
                obj.getClass().getMethod("setProxyPort", classArray2).invoke(obj, objectArray4);
                if (string3 != null && string4 != null) {
                    classArray = new Class[]{Class.forName("java.lang.String")};
                    objectArray3 = new Object[]{string3};
                    obj.getClass().getMethod("setProxyUserName", classArray).invoke(obj, objectArray3);
                    objectArray2 = new Class[]{Class.forName("java.lang.String")};
                    objectArray = new Object[]{string4};
                    obj.getClass().getMethod("setProxyPassword", (Class<?>[])objectArray2).invoke(obj, objectArray);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("proxy host = " + string));
                    this.log.debug((Object)("proxy port = " + string2));
                    this.log.debug((Object)("using proxy username = " + string3));
                }
            }
            uRL = new URL(string5);
            object2 = Class.forName("org.apache.soap.Envelope").newInstance();
            object = Class.forName("org.apache.soap.Body").newInstance();
            classArray2 = null;
            objectArray4 = new Vector();
            classArray = document.getDocumentElement();
            objectArray4.add(document.getFirstChild());
            objectArray3 = new Class[]{Class.forName("java.util.Vector")};
            objectArray2 = new Object[]{objectArray4};
            object.getClass().getMethod("setBodyEntries", (Class<?>[])objectArray3).invoke(object, objectArray2);
            objectArray = new Class[]{Class.forName("org.apache.soap.Body")};
            Object[] objectArray5 = new Object[]{object};
            object2.getClass().getMethod("setBody", (Class<?>[])objectArray).invoke(object2, objectArray5);
            Object obj2 = Class.forName("org.apache.soap.messaging.Message").newInstance();
            Class[] classArray3 = new Class[]{Class.forName("org.apache.soap.transport.SOAPTransport")};
            Object[] objectArray6 = new Object[]{obj};
            obj2.getClass().getMethod("setSOAPTransport", classArray3).invoke(obj2, objectArray6);
            Class[] classArray4 = new Class[]{Class.forName("java.net.URL"), Class.forName("java.lang.String"), Class.forName("org.apache.soap.Envelope")};
            Object[] objectArray7 = new Object[]{uRL, "", object2};
            obj2.getClass().getMethod("send", classArray4).invoke(obj2, objectArray7);
            Object object3 = obj2.getClass().getMethod("receiveEnvelope", null).invoke(obj2, null);
            Object object4 = object3.getClass().getMethod("getBody", null).invoke(object3, null);
            Vector vector = (Vector)object4.getClass().getMethod("getBodyEntries", null).invoke(object4, null);
            element = (Element)vector.firstElement();
        }
        catch (MalformedURLException malformedURLException) {
            throw new JAXRException("Invalid or Malformed URL. ", (Throwable)malformedURLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRException("Make sure soap.jar is present", (Throwable)classNotFoundException);
        }
        catch (Exception exception) {
            throw new JAXRException((Throwable)exception);
        }
        return element;
    }

    private void printNode(Node node) {
        System.out.println(node.toString() + ", localName=" + node.getLocalName() + " nodeName=" + node.getNodeName());
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.printNode(nodeList.item(n2));
            ++n2;
        }
    }
}

