/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class XmlWriter {
    private static final boolean shouldPrettyprint = false;
    private BufferedWriter out;
    private char quoteChar = (char)34;
    private int depth = 0;
    private boolean inStart = false;
    private boolean needNewline = false;
    private boolean writtenChars = false;
    private boolean inAttribute = false;
    private boolean inAttributeValue = false;

    private XmlWriter(OutputStreamWriter w, boolean declare) throws IOException {
        this.out = new BufferedWriter(w, 1024);
        String enc = w.getEncoding();
        if (enc.equals("UTF8")) {
            enc = "UTF-8";
        } else if (enc.equals("ASCII")) {
            enc = "US-ASCII";
        }
        if (declare) {
            this.out.write("<?xml version=\"1.0\" encoding=\"" + enc + "\"?>");
            this.out.newLine();
            this.needNewline = true;
        }
    }

    public XmlWriter(OutputStream out, String enc, boolean declare) throws UnsupportedEncodingException, IOException {
        this(new OutputStreamWriter(out, enc), declare);
    }

    public XmlWriter(OutputStream out, String enc) throws UnsupportedEncodingException, IOException {
        this(new OutputStreamWriter(out, enc), true);
    }

    public XmlWriter(OutputStream out) throws IOException {
        this(new OutputStreamWriter(out, "UTF-8"), true);
    }

    public void setQuote(char quote) {
        if (quote != '\"' && quote != '\'') {
            throw new IllegalArgumentException("Illegal quote character: " + quote);
        }
        this.quoteChar = quote;
    }

    private void quote(char c) throws IOException {
        switch (c) {
            case '&': {
                this.out.write("&amp;");
                break;
            }
            case '<': {
                this.out.write("&lt;");
                break;
            }
            case '>': {
                this.out.write("&gt;");
                break;
            }
            default: {
                this.out.write(c);
            }
        }
    }

    private void aquote(char c) throws IOException {
        switch (c) {
            case '\'': {
                if (this.quoteChar == c) {
                    this.out.write("&apos;");
                    break;
                }
                this.out.write(c);
                break;
            }
            case '\"': {
                if (this.quoteChar == c) {
                    this.out.write("&quot;");
                    break;
                }
                this.out.write(c);
                break;
            }
            default: {
                this.quote(c);
            }
        }
    }

    private void quote(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.quote(s.charAt(i));
            ++i;
        }
    }

    private void aquote(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.aquote(s.charAt(i));
            ++i;
        }
    }

    private void indent(int depth) throws IOException {
        int i = 0;
        while (i < depth) {
            this.out.write("  ");
            ++i;
        }
    }

    public void doctype(String root, String dtd) throws IOException {
        this.needNewline = true;
        this.out.write("<!DOCTYPE " + root + " SYSTEM " + this.quoteChar);
        this.quote(dtd);
        this.out.write(this.quoteChar + ">");
    }

    private void start0(String name) throws IOException {
        this.finishStart();
        this.out.write(60);
        this.out.write(name);
        this.inStart = true;
        this.writtenChars = false;
        ++this.depth;
    }

    private void start1(String name) throws IOException {
        this.finishStart();
        this.out.write(60);
        this.out.write(name);
        this.inStart = true;
        this.writtenChars = false;
        ++this.depth;
    }

    private void finishStart() throws IOException {
        if (this.inStart) {
            if (this.inAttribute) {
                this.out.write(this.quoteChar);
            }
            this.out.write(62);
            this.inStart = false;
            this.inAttribute = false;
            this.inAttributeValue = false;
        }
    }

    public void start(String name) throws IOException {
        this.start1(name);
    }

    public void attribute(String name, String value) throws IOException {
        this.attributeName(name);
        this.attributeValue(value);
    }

    public void attributeName(String name) throws IOException {
        if (!this.inStart) {
            throw new IllegalStateException();
        }
        if (this.inAttribute) {
            this.out.write(this.quoteChar);
            this.inAttribute = false;
            this.inAttributeValue = false;
        }
        this.out.write(32);
        this.out.write(name);
        this.out.write(61);
        this.out.write(this.quoteChar);
        this.inAttribute = true;
    }

    public void attributeValue(String value) throws IOException {
        if (!this.inAttribute || this.inAttributeValue) {
            throw new IllegalStateException();
        }
        this.aquote(value);
        this.out.write(this.quoteChar);
        this.inAttribute = false;
    }

    public void attributeValueToken(String token) throws IOException {
        if (!this.inAttribute) {
            throw new IllegalStateException();
        }
        if (this.inAttributeValue) {
            this.out.write(32);
        }
        this.aquote(token);
        this.inAttributeValue = true;
    }

    public void end(String name) throws IOException {
        if (this.inStart) {
            if (this.inAttribute) {
                this.out.write(this.quoteChar);
            }
            this.out.write("/>");
            this.inStart = false;
            this.inAttribute = false;
            this.inAttributeValue = false;
        } else {
            this.out.write("</");
            this.out.write(name);
            this.out.write(62);
        }
        --this.depth;
        this.writtenChars = false;
    }

    public void chars(String chars) throws IOException {
        this.finishStart();
        this.quote(chars);
        this.writtenChars = true;
    }

    public void leaf(String name, String chars) throws IOException {
        this.start1(name);
        if (chars != null && chars.length() != 0) {
            this.chars(chars);
        }
        this.end(name);
    }

    public void inlineLeaf(String name, String chars) throws IOException {
        this.start0(name);
        if (chars != null && chars.length() != 0) {
            this.chars(chars);
        }
        this.end(name);
    }

    public void leaf(String name) throws IOException {
        this.leaf(name, null);
    }

    public void inlineLeaf(String name) throws IOException {
        this.inlineLeaf(name, null);
    }

    public void flush() throws IOException {
        if (this.depth != 0) {
            throw new IllegalStateException("Nonzero depth");
        }
        this.out.newLine();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

