/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.config.parser;

import com.sun.xml.rpc.processor.config.HandlerChainInfo;
import com.sun.xml.rpc.processor.config.HandlerInfo;
import com.sun.xml.rpc.processor.config.ImportedDocumentInfo;
import com.sun.xml.rpc.processor.config.ModelInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.processor.config.TypeMappingInfo;
import com.sun.xml.rpc.processor.config.TypeMappingRegistryInfo;
import com.sun.xml.rpc.processor.config.parser.Constants;
import com.sun.xml.rpc.processor.config.parser.HandlerChainInfoData;
import com.sun.xml.rpc.processor.config.parser.ParserUtil;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class ModelInfoParser {
    public abstract ModelInfo parse(XMLReader var1);

    protected TypeMappingRegistryInfo parseTypeMappingRegistryInfo(XMLReader reader) {
        TypeMappingRegistryInfo typeMappingRegistryInfo = new TypeMappingRegistryInfo();
        boolean readyForImport = true;
        boolean gotAdditionalTypes = false;
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_IMPORT)) {
                if (!readyForImport) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                }
                readyForImport = false;
                while (reader.nextElementContent() != 2) {
                    if (reader.getName().equals(Constants.QNAME_SCHEMA)) {
                        String namespace = ParserUtil.getMandatoryNonEmptyAttribute(reader, "namespace");
                        String location = ParserUtil.getMandatoryNonEmptyAttribute(reader, "location");
                        ImportedDocumentInfo docInfo = new ImportedDocumentInfo(1);
                        docInfo.setNamespace(namespace);
                        docInfo.setLocation(location);
                        typeMappingRegistryInfo.addImportedDocument(docInfo);
                        ParserUtil.ensureNoContent(reader);
                        continue;
                    }
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                }
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_TYPE_MAPPING)) {
                if (gotAdditionalTypes) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                }
                this.parseTypeMapping(typeMappingRegistryInfo, reader);
                continue;
            }
            if (reader.getName().equals(Constants.QNAME_ADDITIONAL_TYPES)) {
                if (gotAdditionalTypes) {
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                }
                while (reader.nextElementContent() != 2) {
                    if (reader.getName().equals(Constants.QNAME_CLASS)) {
                        String name = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                        typeMappingRegistryInfo.addExtraTypeName(name);
                        ParserUtil.ensureNoContent(reader);
                        continue;
                    }
                    ParserUtil.failWithLocalName("configuration.invalidElement", reader);
                }
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
        return typeMappingRegistryInfo;
    }

    private void parseTypeMapping(TypeMappingRegistryInfo typeMappingRegistryInfo, XMLReader reader) {
        String encodingStyle = ParserUtil.getMandatoryAttribute(reader, "encodingStyle");
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_ENTRY)) {
                this.parseEntry(typeMappingRegistryInfo, encodingStyle, reader);
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
    }

    private void parseEntry(TypeMappingRegistryInfo typeMappingRegistryInfo, String encodingStyle, XMLReader reader) {
        String uri;
        String rawSchemaType = ParserUtil.getMandatoryNonEmptyAttribute(reader, "schemaType");
        String javaTypeName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "javaType");
        String serializerFactoryName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "serializerFactory");
        String deserializerFactoryName = ParserUtil.getMandatoryNonEmptyAttribute(reader, "deserializerFactory");
        ParserUtil.ensureNoContent(reader);
        String prefix = XmlUtil.getPrefix(rawSchemaType);
        String string = uri = prefix == null ? null : reader.getURI(prefix);
        if (prefix != null && uri == null) {
            ParserUtil.failWithLocalName("configuration.configuration.invalid.attribute.value", reader, rawSchemaType);
        }
        String localPart = XmlUtil.getLocalPart(rawSchemaType);
        QName xmlType = new QName(uri, localPart);
        TypeMappingInfo i = new TypeMappingInfo(encodingStyle, xmlType, javaTypeName, serializerFactoryName, deserializerFactoryName);
        typeMappingRegistryInfo.addMapping(i);
    }

    protected HandlerChainInfoData parseHandlerChainInfoData(XMLReader reader) {
        HandlerChainInfoData data = new HandlerChainInfoData();
        boolean gotClient = false;
        boolean gotServer = false;
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_CHAIN)) {
                String runatAttr = ParserUtil.getMandatoryNonEmptyAttribute(reader, "runAt");
                if (runatAttr.equals("client")) {
                    if (gotClient) {
                        ParserUtil.failWithLocalName("configuration.handlerChain.duplicate", reader, runatAttr);
                        continue;
                    }
                    data.setClientHandlerChainInfo(this.parseHandlerChainInfo(reader));
                    gotClient = true;
                    continue;
                }
                if (runatAttr.equals("server")) {
                    if (gotServer) {
                        ParserUtil.failWithLocalName("configuration.handlerChain.duplicate", reader, runatAttr);
                        continue;
                    }
                    data.setServerHandlerChainInfo(this.parseHandlerChainInfo(reader));
                    gotServer = true;
                    continue;
                }
                ParserUtil.failWithLocalName("configuration.invalidAttributeValue", reader, "runAt");
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
        return data;
    }

    protected HandlerChainInfo parseHandlerChainInfo(XMLReader reader) {
        HandlerChainInfo chain = new HandlerChainInfo();
        chain.addRole("http://schemas.xmlsoap.org/soap/actor/next");
        String rolesAttr = ParserUtil.getAttribute(reader, "roles");
        if (rolesAttr != null) {
            List rolesList = XmlUtil.parseTokenList(rolesAttr);
            Iterator iter = rolesList.iterator();
            while (iter.hasNext()) {
                chain.addRole((String)iter.next());
            }
        }
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_HANDLER)) {
                chain.add(this.parseHandlerInfo(reader));
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
        return chain;
    }

    protected HandlerInfo parseHandlerInfo(XMLReader reader) {
        HandlerInfo handler = new HandlerInfo();
        String className = ParserUtil.getMandatoryNonEmptyAttribute(reader, "className");
        handler.setHandlerClassName(className);
        String headers = ParserUtil.getAttribute(reader, "headers");
        if (headers != null) {
            List headersList = XmlUtil.parseTokenList(headers);
            Iterator iter = headersList.iterator();
            while (iter.hasNext()) {
                String uri;
                String name = (String)iter.next();
                String prefix = XmlUtil.getPrefix(name);
                String localPart = XmlUtil.getLocalPart(name);
                if (prefix == null) {
                    prefix = "";
                }
                if ((uri = reader.getURI(prefix)) == null) {
                    ParserUtil.failWithLocalName("configuration.invalidAttributeValue", reader, "headers");
                }
                handler.addHeaderName(new QName(uri, localPart));
            }
        }
        Map properties = handler.getProperties();
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_PROPERTY)) {
                String name = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                String value = ParserUtil.getMandatoryAttribute(reader, "value");
                properties.put(name, value);
                ParserUtil.ensureNoContent(reader);
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
        return handler;
    }

    protected NamespaceMappingRegistryInfo parseNamespaceMappingRegistryInfo(XMLReader reader) {
        NamespaceMappingRegistryInfo namespaceMappingRegistryInfo = new NamespaceMappingRegistryInfo();
        while (reader.nextElementContent() != 2) {
            if (reader.getName().equals(Constants.QNAME_NAMESPACE_MAPPING)) {
                this.parseNamespaceMapping(namespaceMappingRegistryInfo, reader);
                continue;
            }
            ParserUtil.failWithLocalName("configuration.invalidElement", reader);
        }
        return namespaceMappingRegistryInfo;
    }

    private void parseNamespaceMapping(NamespaceMappingRegistryInfo namespaceMappingRegistryInfo, XMLReader reader) {
        String namespaceURI = ParserUtil.getMandatoryAttribute(reader, "namespace");
        String javaPackageName = ParserUtil.getMandatoryAttribute(reader, "packageName");
        ParserUtil.ensureNoContent(reader);
        NamespaceMappingInfo i = new NamespaceMappingInfo(namespaceURI, javaPackageName);
        namespaceMappingRegistryInfo.addMapping(i);
    }
}

