/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDDateTimeDateEncoder;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class XSDDateTimeCalendarEncoder
extends XSDDateTimeDateEncoder {
    private static final SimpleTypeEncoder encoder = new XSDDateTimeCalendarEncoder();
    private static Method getDSTSavingsMethod = null;
    private static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final Calendar gmtCalendar = Calendar.getInstance();

    private XSDDateTimeCalendarEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        Calendar c = (Calendar)obj;
        int offset = c.get(15);
        if (c.getTimeZone().inDaylightTime(c.getTime())) {
            offset += ((Integer)getDSTSavingsMethod.invoke((Object)c.getTimeZone(), null)).intValue();
        }
        int offsetHours = offset / 3600000;
        StringBuffer buf = new StringBuffer(5);
        buf.append(offset < 0 ? (char)'-' : '+');
        int n = offsetHours = offsetHours < 0 ? -offsetHours : offsetHours;
        if (offsetHours < 10) {
            buf.append('0');
        }
        buf.append(offsetHours + ":00");
        String offsetStr = new String(buf);
        SimpleDateFormat simpleDateFormat = calendarFormatter;
        synchronized (simpleDateFormat) {
            calendarFormatter.setTimeZone(c.getTimeZone());
            String string = calendarFormatter.format(c.getTime()) + offsetStr;
            return string;
        }
    }

    public Object stringToObject(String str, XMLReader reader) throws Exception {
        Calendar cal;
        if (str == null) {
            return null;
        }
        StringBuffer zone = new StringBuffer(10);
        Date date = XSDDateTimeDateEncoder.decodeDateUtil(str, zone);
        String zoneStr = zone.toString();
        if (zoneStr.length() == 0) {
            cal = Calendar.getInstance(XSDDateTimeDateEncoder.gmtTimeZone);
            cal.setTime(date);
        } else {
            cal = Calendar.getInstance(XSDDateTimeDateEncoder.gmtTimeZone);
            cal.setTime(date);
            TimeZone tz = TimeZone.getTimeZone("GMT" + zoneStr);
            int rawOffset = tz.getRawOffset();
            TimeZone tz2 = TimeZone.getDefault();
            if (tz2.inDaylightTime(date)) {
                rawOffset -= ((Integer)getDSTSavingsMethod.invoke((Object)tz2, null)).intValue();
            }
            tz2.setRawOffset(rawOffset);
            tz2.setID("Custom");
            cal.setTimeZone(tz2);
        }
        return cal;
    }

    public void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    static {
        gmtCalendar.setTimeZone(XSDDateTimeDateEncoder.gmtTimeZone);
        try {
            getDSTSavingsMethod = TimeZone.getDefault().getClass().getMethod("getDSTSavings", null);
        }
        catch (NoSuchMethodException e) {
            System.out.println("FATAL ERROR: no getDSTSavings method defined on TimeZone");
        }
    }
}

