/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectSerializerBase;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class GenericObjectSerializer
extends ObjectSerializerBase
implements Initializable {
    protected Class targetClass = null;
    protected List members = new ArrayList();

    public GenericObjectSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        super(type, encodeType, isNullable, encodingStyle);
    }

    protected void setTargetClass(Class targetClass) {
        this.clearMembers();
        this.doSetTargetClass(targetClass);
        this.targetClass = targetClass;
    }

    protected void doSetTargetClass(Class targetClass) {
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        Iterator eachMember = this.members.iterator();
        while (eachMember.hasNext()) {
            MemberInfo currentMember = (MemberInfo)eachMember.next();
            currentMember.serializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, currentMember.javaType, currentMember.xmlType);
            currentMember.deserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, currentMember.javaType, currentMember.xmlType);
        }
    }

    public void clearMembers() {
        this.members.clear();
    }

    public void addMember(MemberInfo member) throws Exception {
        Iterator eachMember = this.members.iterator();
        while (eachMember.hasNext()) {
            MemberInfo existingMember = (MemberInfo)eachMember.next();
            if (!existingMember.name.equals(member.name)) continue;
            throw new EncodingException("soap.duplicate.data.member", new Object[]{member.name});
        }
        this.members.add(member);
    }

    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        int i = 0;
        while (i < this.members.size()) {
            MemberInfo currentMember = (MemberInfo)this.members.get(i);
            currentMember.serializer.serialize(currentMember.getter.get(instance), currentMember.name, null, writer, context);
            ++i;
        }
    }

    protected Object doDeserialize(SOAPDeserializationState state, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Object instance = this.targetClass.newInstance();
        SOAPGenericObjectInstanceBuilder builder = null;
        boolean isComplete = true;
        int lastMemberIndex = this.members.size() - 1;
        int memberCount = 0;
        while (memberCount <= lastMemberIndex) {
            reader.nextElementContent();
            int memberIndex = memberCount;
            do {
                MemberInfo currentMember = (MemberInfo)this.members.get(memberIndex);
                if (reader.getName().equals(currentMember.name)) {
                    Object member = currentMember.deserializer.deserialize(currentMember.name, reader, context);
                    if (member instanceof SOAPDeserializationState) {
                        if (builder == null) {
                            builder = new SOAPGenericObjectInstanceBuilder(instance);
                        }
                        state = ObjectSerializerBase.registerWithMemberState(instance, state, member, memberIndex, builder);
                        isComplete = false;
                        break;
                    }
                    currentMember.setter.set(instance, member);
                    break;
                }
                if (memberIndex == lastMemberIndex) {
                    memberIndex = 0;
                    continue;
                }
                ++memberIndex;
            } while (memberIndex != memberCount);
            ++memberCount;
        }
        return isComplete ? instance : state;
    }

    protected class SOAPGenericObjectInstanceBuilder
    implements SOAPInstanceBuilder {
        Object instance;

        SOAPGenericObjectInstanceBuilder(Object instance) {
            this.instance = instance;
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int index, Object memberValue) {
            try {
                ((MemberInfo)GenericObjectSerializer.this.members.get((int)index)).setter.set(this.instance, memberValue);
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object instance) {
        }

        public Object getInstance() {
            return this.instance;
        }
    }

    public static class MemberInfo {
        QName name = null;
        QName xmlType = null;
        Class javaType = null;
        JAXRPCSerializer serializer = null;
        JAXRPCDeserializer deserializer = null;
        GetterMethod getter = null;
        SetterMethod setter = null;
    }

    public static interface SetterMethod {
        public void set(Object var1, Object var2) throws Exception;
    }

    public static interface GetterMethod {
        public Object get(Object var1) throws Exception;
    }
}

