/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.jaxm.ebxml;

import com.sun.xml.messaging.jaxm.ebxml.Description;
import com.sun.xml.messaging.jaxm.ebxml.Manifest;
import com.sun.xml.messaging.jaxm.ebxml.Party;
import com.sun.xml.messaging.jaxm.ebxml.Reference;
import com.sun.xml.messaging.jaxm.ebxml.Schema;
import com.sun.xml.messaging.jaxm.ebxml.Service;
import com.sun.xml.messaging.jaxm.util.ProfileMessage;
import com.sun.xml.messaging.jaxm.util.SerializableMessage;
import com.sun.xml.messaging.jaxm.util.UUID;
import com.sun.xml.messaging.jaxm.util.UUIDFactory;
import com.sun.xml.messaging.util.StringManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.messaging.Endpoint;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EbXMLMessageImpl
extends ProfileMessage {
    public static final Log logger = LogFactory.getFactory().getInstance("com.sun.xml.messaging.jaxm.ebxml");
    private StringManager sm = StringManager.getManager((String)"com.sun.xml.messaging.jaxm.ebxml");
    private Party sender;
    private Party receiver;
    private String messageId = "";
    private String refToMessageId = "";
    private boolean isInitMessage = false;
    private static final String NS_URI = "http://www.ebxml.org/namespaces/messageHeader";
    private static final String NS_PREFIX = "eb";
    private static final String XLINK_NS_URI = "http://www.w3.org/1999/xlink";
    private static final String XLINK_NS_PREFIX = "xlink";
    private static final String XML_NS_URI = "http://www.w3.org/XML/1998/namespace";
    private static final String XML_NS_PREFIX = "xml";
    private SOAPPart sp;
    private SOAPEnvelope envelope;
    private SOAPHeader header;
    private long timeStamp;
    private String version = "1.0";
    private String action = null;
    private String cpaId;
    private String conversationId;
    private Service service;
    private Manifest manifest;
    static /* synthetic */ Class class$com$sun$xml$messaging$jaxm$ebxml$EbXMLMessageFactoryImpl;

    public EbXMLMessageImpl() throws SOAPException {
        this.newMessageId();
        this.setTimeStamp(this.newTimeStamp());
        this.sp = this.getSOAPPart();
        this.envelope = this.sp.getEnvelope();
        this.header = this.envelope.getHeader();
    }

    void setIsInitMessage(boolean isInitMessage) {
        this.isInitMessage = isInitMessage;
    }

    public EbXMLMessageImpl(MimeHeaders headers, InputStream in) throws IOException, SOAPException {
        super(headers, in);
        this.fillInHeaders();
    }

    public EbXMLMessageImpl(SOAPMessage message) throws IOException, SOAPException {
        super(message);
        this.fillInHeaders();
    }

    private void fillInHeaders() {
        try {
            SOAPPart sp = this.getSOAPPart();
            SOAPEnvelope env = sp.getEnvelope();
            SOAPHeader hdr = env.getHeader();
            SOAPBody body = env.getBody();
            Iterator it = hdr.getChildElements();
            Name name = null;
            while (it.hasNext()) {
                SOAPHeaderElement elem = (SOAPHeaderElement)it.next();
                name = elem.getElementName();
                if (!this.compare(name, "MessageHeader")) continue;
                this.setMessageHeader((SOAPElement)elem, env);
                break;
            }
            it = body.getChildElements();
            SOAPBodyElement bodyElem = null;
            while (it.hasNext()) {
                bodyElem = (SOAPBodyElement)it.next();
                name = bodyElem.getElementName();
                if (!this.compare(name, "Manifest")) continue;
                this.setManifestData((SOAPElement)bodyElem, env);
                break;
            }
        }
        catch (SOAPException se) {
            logger.error((Object)this.sm.getString("jaxm.ebxml.error.fill.headers"), (Throwable)se);
            se.printStackTrace();
        }
    }

    private void setMessageHeader(SOAPElement element, SOAPEnvelope env) throws SOAPException {
        Name name = null;
        SOAPElement elem = null;
        Iterator it = element.getChildElements();
        while (it.hasNext()) {
            elem = (SOAPElement)it.next();
            name = elem.getElementName();
            if (this.compare(name, "From")) {
                this.sender = this.getParty(elem, env);
                continue;
            }
            if (this.compare(name, "To")) {
                this.receiver = this.getParty(elem, env);
                continue;
            }
            if (this.compare(name, "CPAId")) {
                this.cpaId = elem.getValue();
                continue;
            }
            if (this.compare(name, "ConversationId")) {
                this.conversationId = elem.getValue();
                continue;
            }
            if (this.compare(name, "Service")) {
                this.setServiceData(elem, env);
                continue;
            }
            if (this.compare(name, "Action")) {
                this.action = elem.getValue();
                continue;
            }
            if (!this.compare(name, "MessageData")) continue;
            this.setMessageData(elem);
        }
    }

    private void setManifestData(SOAPElement element, SOAPEnvelope env) throws SOAPException {
        Name name = env.createName("id", NS_PREFIX, NS_URI);
        String id = element.getAttributeValue(name);
        name = env.createName("version", NS_PREFIX, NS_URI);
        String version = element.getAttributeValue(name);
        this.manifest = new Manifest(id, version);
        Iterator it = element.getChildElements();
        SOAPElement elem = null;
        while (it.hasNext()) {
            elem = (SOAPElement)it.next();
            name = elem.getElementName();
            if (!this.compare(name, "Reference")) continue;
            Reference ref = this.getReference(elem, env);
            this.manifest.addReference(ref);
        }
    }

    private Reference getReference(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        Name name = env.createName("href", XLINK_NS_PREFIX, XLINK_NS_URI);
        String xlinkHref = elem.getAttributeValue(name);
        name = env.createName("role", XLINK_NS_PREFIX, XLINK_NS_URI);
        String xlinkRole = elem.getAttributeValue(name);
        name = env.createName("id", NS_PREFIX, NS_URI);
        String id = elem.getAttributeValue(name);
        Reference ref = new Reference(id, xlinkHref, xlinkRole);
        Iterator it = elem.getChildElements();
        SOAPElement element = null;
        String location = null;
        String version = null;
        while (it.hasNext()) {
            element = (SOAPElement)it.next();
            name = element.getElementName();
            if (this.compare(name, "Schema")) {
                location = element.getAttributeValue(env.createName("location", NS_PREFIX, NS_URI));
                version = element.getAttributeValue(env.createName("version", NS_PREFIX, NS_URI));
                Schema schema = new Schema(location, version);
                ref.setSchema(schema);
                continue;
            }
            if (!this.compare(name, "Description")) continue;
            String lang = element.getAttributeValue(env.createName("lang", XML_NS_PREFIX, XML_NS_URI));
            Description desc = new Description(lang);
            desc.setText(element.getValue());
            ref.setDescription(desc);
        }
        return ref;
    }

    private void setServiceData(SOAPElement element, SOAPEnvelope env) throws SOAPException {
        Name name = env.createName("type", NS_PREFIX, NS_URI);
        String type = element.getAttributeValue(name);
        this.service = type == null ? new Service(element.getValue()) : new Service(element.getValue(), type);
    }

    private void setMessageData(SOAPElement element) {
        Iterator it = element.getChildElements();
        Name name = null;
        SOAPElement elem = null;
        while (it.hasNext()) {
            elem = (SOAPElement)it.next();
            name = elem.getElementName();
            if (this.compare(name, "MessageId")) {
                this.messageId = elem.getValue();
                continue;
            }
            if (this.compare(name, "RefToMessageId")) {
                this.refToMessageId = elem.getValue();
                continue;
            }
            if (!this.compare(name, "Timestamp")) continue;
            this.timeStamp = Long.parseLong(elem.getValue());
        }
    }

    private Party getParty(SOAPElement element, SOAPEnvelope env) throws SOAPException {
        Iterator it = element.getChildElements();
        SOAPElement elem = null;
        Party party = null;
        Name name = null;
        while (it.hasNext()) {
            elem = (SOAPElement)it.next();
            name = elem.getElementName();
            if (!this.compare(name, "PartyId")) continue;
            name = env.createName("type", NS_PREFIX, NS_URI);
            String type = elem.getAttributeValue(name);
            party = type == null ? new Party(elem.getValue()) : new Party(elem.getValue(), type);
        }
        return party;
    }

    public synchronized void saveChanges() throws SOAPException {
        this.addHeaders();
        super.saveChanges();
    }

    public void setMessageHeaderVersion(String version) throws SOAPException {
        if (!version.equals("1.0")) {
            throw new SOAPException("Currently the only value supported is 1.0");
        }
        this.version = version;
    }

    public String getMessageHeaderVersion() {
        return this.version;
    }

    public Party getSender() {
        return this.sender;
    }

    public void setSender(Party sender) {
        this.sender = sender;
    }

    public Party getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Party receiver) {
        this.receiver = receiver;
    }

    public Endpoint getFrom() {
        return new Endpoint(this.getSender().getPartyId());
    }

    public Endpoint getTo() {
        return new Endpoint(this.getReceiver().getPartyId());
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Service getService() {
        return this.service;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public String getMessageId() {
        return this.messageId;
    }

    private void newMessageId() {
        UUIDFactory factory = new UUIDFactory();
        UUID uuid = factory.newUUID();
        this.messageId = uuid.toString();
    }

    public String getRefToMessageId() {
        return this.refToMessageId;
    }

    public void setRefToMessageId(String refToMessageId) {
        this.refToMessageId = refToMessageId;
    }

    private long newTimeStamp() {
        return System.currentTimeMillis();
    }

    private void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    private long getTimeStamp() {
        return this.timeStamp;
    }

    public void setCPAId(String cpaId) {
        this.cpaId = cpaId;
    }

    public String getCPAId() {
        return this.cpaId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    private void addHeaders() throws SOAPException {
        Reference[] references;
        SOAPHeaderElement e;
        SOAPPart sp = this.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPHeader header = envelope.getHeader();
        SOAPBody body = envelope.getBody();
        Iterator i = header.getChildElements();
        Name name = null;
        while (i.hasNext()) {
            e = (SOAPHeaderElement)i.next();
            name = e.getElementName();
            if (!this.compare(name, "MessageHeader")) continue;
            e.detachNode();
            break;
        }
        i = body.getChildElements();
        while (i.hasNext()) {
            e = (SOAPBodyElement)i.next();
            name = e.getElementName();
            if (!this.compare(name, "Manifest")) continue;
            e.detachNode();
            break;
        }
        SOAPHeaderElement messageHeader = null;
        if (this.sender != null && this.receiver != null) {
            messageHeader = header.addHeaderElement(envelope.createName("MessageHeader", NS_PREFIX, NS_URI));
            messageHeader.addAttribute(envelope.createName("version", NS_PREFIX, NS_URI), this.version);
            messageHeader.addAttribute(envelope.createName("mustUnderstand", "soap-env", "http://schemas.xmlsoap.org/soap/envelope/"), "1");
            SOAPElement fromElement = messageHeader.addChildElement("From", NS_PREFIX);
            SOAPElement fromPartyId = fromElement.addChildElement("PartyId", NS_PREFIX);
            fromPartyId.addAttribute(envelope.createName("type", NS_PREFIX, NS_URI), this.sender.getType());
            fromPartyId.addTextNode(this.sender.getPartyId());
            SOAPElement toElement = messageHeader.addChildElement("To", NS_PREFIX);
            SOAPElement toPartyId = toElement.addChildElement("PartyId", NS_PREFIX);
            toPartyId.addAttribute(envelope.createName("type", NS_PREFIX, NS_URI), this.receiver.getType());
            toPartyId.addTextNode(this.receiver.getPartyId());
            if (this.cpaId != null && this.cpaId != "") {
                SOAPElement cpaIdElement = messageHeader.addChildElement("CPAId", NS_PREFIX);
                cpaIdElement.addTextNode(this.cpaId);
            }
            if (this.conversationId != null && this.conversationId != "") {
                SOAPElement conversationIdElement = messageHeader.addChildElement("ConversationId", NS_PREFIX);
                conversationIdElement.addTextNode(this.conversationId);
            }
            if (this.service != null) {
                SOAPElement serviceElement = messageHeader.addChildElement("Service", NS_PREFIX);
                serviceElement.addTextNode(this.service.getData());
                serviceElement.addAttribute(envelope.createName("type", NS_PREFIX, NS_URI), this.service.getType());
            }
            if (this.action != null) {
                SOAPElement actionElement = messageHeader.addChildElement("Action", NS_PREFIX);
                actionElement.addTextNode(this.action);
            }
            SOAPElement messageDataElement = null;
            messageDataElement = messageHeader.addChildElement("MessageData", NS_PREFIX);
            SOAPElement msgId = messageDataElement.addChildElement("MessageId", NS_PREFIX);
            msgId.addTextNode(this.messageId);
            if (this.refToMessageId != null && this.refToMessageId != "") {
                SOAPElement refToMsgId = messageDataElement.addChildElement("RefToMessageId", NS_PREFIX);
                refToMsgId.addTextNode(this.refToMessageId);
            }
            SOAPElement timeStampElement = messageDataElement.addChildElement("Timestamp", NS_PREFIX);
            timeStampElement.addTextNode(Long.toString(this.getTimeStamp()));
        }
        if (this.manifest != null && (references = this.manifest.getReferences()).length > 0) {
            SOAPBodyElement manifestElement = body.addBodyElement(envelope.createName("Manifest", NS_PREFIX, NS_URI));
            manifestElement.addAttribute(envelope.createName("id", NS_PREFIX, NS_URI), this.manifest.getId());
            manifestElement.addAttribute(envelope.createName("version", NS_PREFIX, NS_URI), this.manifest.getVersion());
            SOAPElement refElement = null;
            Reference ref = null;
            int k = 0;
            while (k < references.length) {
                Description desc;
                Schema schema;
                refElement = manifestElement.addChildElement("Reference", NS_PREFIX);
                ref = references[k];
                refElement.addAttribute(envelope.createName("id", NS_PREFIX, NS_URI), ref.getId());
                if (ref.getXLinkHref() != null && ref.getXLinkHref() != "") {
                    refElement.addAttribute(envelope.createName("href", XLINK_NS_PREFIX, XLINK_NS_URI), ref.getXLinkHref());
                }
                if (ref.getXLinkRole() != null && ref.getXLinkRole() != "") {
                    refElement.addAttribute(envelope.createName("role", XLINK_NS_PREFIX, XLINK_NS_URI), ref.getXLinkRole());
                }
                if ((schema = ref.getSchema()) != null) {
                    SOAPElement schemaElement = refElement.addChildElement("Schema", NS_PREFIX);
                    schemaElement.addAttribute(envelope.createName("version", NS_PREFIX, NS_URI), schema.getVersion());
                    schemaElement.addAttribute(envelope.createName("location", NS_PREFIX, NS_URI), schema.getLocation());
                }
                if ((desc = ref.getDescription()) != null) {
                    SOAPElement descElement = refElement.addChildElement("Description", NS_PREFIX);
                    descElement.addAttribute(envelope.createName("lang", XML_NS_PREFIX, XML_NS_URI), desc.getLang());
                    descElement.addTextNode(desc.getText());
                }
                ++k;
            }
        }
    }

    public SerializableMessage getSerializableMessage() {
        return new SerializableMessage((SOAPMessage)this, class$com$sun$xml$messaging$jaxm$ebxml$EbXMLMessageFactoryImpl == null ? (class$com$sun$xml$messaging$jaxm$ebxml$EbXMLMessageFactoryImpl = EbXMLMessageImpl.class$("com.sun.xml.messaging.jaxm.ebxml.EbXMLMessageFactoryImpl")) : class$com$sun$xml$messaging$jaxm$ebxml$EbXMLMessageFactoryImpl);
    }

    private final boolean compare(Name got, String localName) {
        return got.getLocalName().equalsIgnoreCase(localName) && got.getURI().equalsIgnoreCase(NS_URI);
    }

    private final Name createEbXMLName(String localName, SOAPEnvelope env) throws SOAPException {
        return env.createName(localName, NS_PREFIX, NS_URI);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

