<%@ page  language="java"
          import="at.salzburgresearch.applications.trainreservation.actionforms.*"
          errorPage="error.jsp"%>

<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>

<html:html locale="true">

<head>
<title><bean:message key="SelectTrainView.title"/></title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="expires" content="0">
<html:base/>
</head>

<body bgcolor="#FFFFFF">

<p>
  <font face="Verdana, Arial, Helvetica, sans-serif" color="#CC0000">
    <bean:message key="message.header"/>
  </font>
</p>

<p>
  <bean:message key="SelectTrainView.header1"/>
</p>

<hr>

<!-- struts-tag for html-form, used ActionForm: SelectTrainForm,
     for mapping the Action-URL to the Struts-ActionServlet a
     postfix-mapping for "*.do" is configured in the web.xml
-->
<html:form action="selecttrain.do">
  <font color="#CC0000">
    <!-- show error messages -->
    <html:errors property="train_error"/>
    <html:errors property="nocoaches_error"/>
  </font>
  <table width="25%" border=0 cellpadding=2 cellspacing=1>

    <tr bgcolor="#CCCCCC">
      <th align="LEFT"> <font color="#000000"><b>&nbsp;</b></font></th>
      <th colspan="2"> <font color="#000000"><b>
        <!-- internationalized struts-message -->
        <bean:message key="SelectTrainView.table.column1"/></b></font></th>
    </tr>

    <!-- copy the trains-collection of the timetable-bean to scope 'page' -->
    <bean:define  id="TRAINS"
                  name="TIMETABLE"
                  property="trains"
                  scope="session"
                  toScope="page"
                  type="java.util.Collection"/>

    <!-- iterate over trains-collection -->
    <logic:iterate  id="TRAINRADIOBUTTON"
                    name="TRAINS"
                    type="at.salzburgresearch.applications.trainreservation.datamodel.Train">
      <tr bgcolor="#E0E0E0">
        <td align="CENTER" valign="TOP">
          <!--  insert radio-button,
                property selectedTrain is the property of the ActionForm -->
          <html:radio property="selectedTrain"
                      value="<%=TRAINRADIOBUTTON.getTrainNum()%>"/>
        </td>
        <td valign="MIDDLE" colspan="2" NOWRAP>
          <!-- insert the value of the property trainNum of the trains-collection -->
          <bean:write name="TRAINRADIOBUTTON"
                      property="trainNum"/>
        </td>
      </tr>
    </logic:iterate>

  </table>

  <!-- begin selection of day and month -->
  <p align="left"><bean:message key="SelectTrainView.header2"/></p>
  <p>
    <bean:message key="SelectTrainView.day"/>
    <!-- insert select-field with the property day of the ActionForm -->
    <html:select  property="day"
                  value="<%=SelectTrainForm.actualDay()%>">
      <!--  insert the values of the collection-property daysOfMonth of the
            ActionForm -->
      <html:options property="daysOfMonth"/>
    </html:select>


    <bean:message key="SelectTrainView.month"/>
    <!-- insert select-field with the property month of the ActionForm -->
    <html:select property="month" value="<%=SelectTrainForm.actualMonth()%>">
      <!-- insert constant option-values -->
      <html:option value="1"/><html:option value="2"/><html:option value="3"/>
      <html:option value="4"/><html:option value="5"/><html:option value="6"/>
      <html:option value="7"/><html:option value="8"/><html:option value="9"/>
      <html:option value="10"/><html:option value="11"/><html:option value="12"/>
    </html:select>

    <!-- insert actual year, reservations are only possible for the actual year -->
    <bean:message key="SelectTrainView.year"/>
    <%=SelectTrainForm.actualYear()%>

  </p>

  <p align="left">
    <!--  submit button for submitting the form, the value is saved in
          property action of the ActionForm -->
    <html:submit property="action">
      <bean:message key="SelectTrainView.next"/>
    </html:submit>
    <bean:message key="SelectTrainView.login"/>
  </p>
  <hr>
  <p>
    <!-- struts-link for going back -->
    <html:link forward="Start">
      <bean:message key="SelectTrainView.back"/>
    </html:link>
  </p>
</html:form>

</body>
</html:html>

