package at.salzburgresearch.applications.trainreservation.db;

import java.util.*;
import java.text.*;

import at.salzburgresearch.applications.trainreservation.datamodel.*;
import at.salzburgresearch.applications.trainreservation.utils.*;


/**
 * Title: InMemoryDB.java
 * Description: For holding application-data without a real db
 * Copyright: Copyright (c) 2002
 * Company: Salzburg Research
 * @author Karl Rehrl
 * @version 1.0
 */

public class InMemoryDB implements IDBAccess {

  private static Timetable timetable = null;
  private static ArrayList reservations = null;

  // initialize data
  static {
    timetable = new Timetable();
    ArrayList trains = new ArrayList();
    timetable.setTrains(trains);
    ArrayList coaches = new ArrayList();
    ArrayList seats = new ArrayList();

    // train Tauernexpress
    Train train = new Train("Tauernexpress");
    train.setCoaches(coaches);
    // add coach 15
    Coach coach = new Coach("15", train);
    for (int i=1; i <= 44; i++) {
      seats.add(new Seat(new Integer(i).toString(), coach, false));
    }
    coach.setSeats(seats);
    coaches.add(coach);
    // add coach 65
    coach = new Coach("65", train);
    seats = new ArrayList();
    for (int i=1; i <= 20; i++) {
      seats.add(new Seat(new Integer(i).toString(), coach, false));
    }
    coach.setSeats(seats);
    coaches.add(coach);
    trains.add(train);

    // train Alpenflitzer
    train = new Train("Alpenflitzer");
    coaches = new ArrayList();
    train.setCoaches(coaches);
    // add coach 12
    coach = new Coach("12", train);
    seats = new ArrayList();
    for (int i=1; i <= 50; i++) {
      seats.add(new Seat(new Integer(i).toString(), coach, false));
    }
    coach.setSeats(seats);
    coaches.add(coach);
    // add coach 23
    coach = new Coach("23", train);
    seats = new ArrayList();
    for (int i=1; i <= 25; i++) {
      seats.add(new Seat(new Integer(i).toString(), coach, false));
    }
    coach.setSeats(seats);
    coaches.add(coach);
    // add coach 33
    coach = new Coach("33", train);
    seats = new ArrayList();
    for (int i=1; i <= 33; i++) {
      seats.add(new Seat(new Integer(i).toString(), coach, false));
    }
    coach.setSeats(seats);
    coaches.add(coach);
    // set coaches to trains
    trains.add(train);

    // train Almenbummler
    train = new Train("Almenbummler");
    coaches = new ArrayList();
    train.setCoaches(coaches);
    trains.add(train);

    // reservations
    reservations = new ArrayList();

  }


  /**
   * Returns the trains from the static field timetable
   */
  public Collection getTrains() {
    return timetable.getTrains();
  }


  /**
   * Returns the coaches for a trainNum
   * @param trainNum
   */
  public Collection getCoaches(String trainNum) {
    Iterator it = timetable.getTrains().iterator();
    while (it.hasNext()) {
      Train train = (Train)it.next();
      if (train.getTrainNum().equals(trainNum)) return train.getCoaches();
    }
    return new ArrayList();
  }


  /**
   * Returns the reserved seat numbers for trainNum, coachNum and date
   * @param trainNum
   * @param coachNum
   * @param travelDate
   */
  public Collection getReservedSeatNums(
    String trainNum, String coachNum, String travelDate) {

    ArrayList seatNums = new ArrayList();

    // iterate over reservations
    Iterator reservationIt = reservations.iterator();
    while (reservationIt.hasNext()) {
      Reservation reservation = (Reservation)reservationIt.next();
      String date = new SimpleDateFormat("dd.MM.yyyy").format(reservation.getTravelDate());
      if (trainNum.equals(reservation.getTrainNum()) &&
          coachNum.equals(reservation.getCoachNum()) &&
          travelDate.equals(date)) {

        // iterate over seats
        Iterator seatIt = reservation.getSeats().iterator();
        while (seatIt.hasNext()) {
          Seat seat = (Seat)seatIt.next();
          seatNums.add(seat.getSeatNum());
          Debug.print(this.getClass().getName(),
            "Found reserved seat: "+seat.getSeatNum());
        }
      }
    }
    return seatNums;
  }


  /**
   * saves the reservation-data in the static field reservations
   * @param reservation Reference to the reservation-data
   */
  public synchronized void saveReservation(Reservation reservation) throws DBException {
    // check if selected seats are not reserved already
    // iterate over existing reservations
    Iterator res_it = reservations.iterator();
    while (res_it.hasNext()) {
      Reservation res = (Reservation)res_it.next();
      // format dates for comparison
      String res_date =
        new SimpleDateFormat("dd.MM.yyyy").format(res.getTravelDate());
      String reservation_date =
        new SimpleDateFormat("dd.MM.yyyy").format(reservation.getTravelDate());
      // reservation with trainNum, coachNum and date found
      if (res.getTrainNum().equals(reservation.getTrainNum()) &&
          res.getCoachNum().equals(reservation.getCoachNum()) &&
          res_date.equals(reservation_date)) {
        // iterate over seats of reservation
        Iterator seat_res_it = res.getSeats().iterator();
        while (seat_res_it.hasNext()) {
          Seat seat_res = (Seat)seat_res_it.next();
          // iterate over seats of res
          Iterator seat_reservation_it = reservation.getSeats().iterator();
          while (seat_reservation_it.hasNext()) {
            Seat seat_reservation = (Seat)seat_reservation_it.next();
            // found, that seat is already reserved
            if (seat_reservation.getSeatNum().equals(seat_res.getSeatNum()))
              throw new DBException("SelectSeatsView.errors.seatsnotavailable");
          }
        }
      }
    }
    reservations.add(reservation);
    Debug.print(this.getClass().getName(), "Reservation complete");
  }

}