package at.salzburgresearch.applications.trainreservation.db;

import at.salzburgresearch.applications.trainreservation.datamodel.*;
import java.util.*;

/**
 * Title: IDBAccess.java
 * Description: Interface for db-access methods, is used for implementing
 *              DBAccess for access to a real db and InMemoryDB for holding
 *              data in memory.
 * Copyright: Copyright (c) 2002
 * Company: Salzburg Research
 * @author Karl Rehrl
 * @version 1.0
 */

public interface IDBAccess {

  public Collection getTrains();
  public Collection getCoaches(String trainNum);
  public Collection getReservedSeatNums(
    String trainNum, String coachNum, String travelDate);
  public void saveReservation(Reservation reservation) throws DBException;

}