package at.salzburgresearch.applications.trainreservation.actions;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.struts.action.*;

import at.salzburgresearch.applications.trainreservation.datamodel.*;
import at.salzburgresearch.applications.trainreservation.db.*;
import at.salzburgresearch.applications.trainreservation.utils.*;

/**
 * Title: ViewDispatchAction.java
 * Description: Dispatch to views through the controller
 * Copyright:    Copyright (c) 2002
 * Company: Salzburg Research
 * @author Karl Rehrl
 * @version 1.0
 */

public class ViewDispatchAction extends Action {

  /**
   * Called from the Struts-Controller-Servlet
   */
  public ActionForward perform(ActionMapping mapping,
                               ActionForm form,
                               HttpServletRequest request,
                               HttpServletResponse response)
    throws IOException, ServletException {

    // get session
    HttpSession session = request.getSession();

    // get parameter
    String forward = request.getParameter("forward");

    if (forward != null && forward.length() > 0) {
      // dispatch to SelectTrainView
      if ("SelectTrainView".equals(forward) && session.getAttribute(Keys.TIMETABLE) == null) {
        Timetable t = new Timetable();
        try {
          t.setTrains(((IDBAccess)Class.forName(Keys.DB_CLASS).newInstance()).getTrains());
        } catch (ClassNotFoundException cnfe) { cnfe.printStackTrace();
        } catch (IllegalAccessException iae) { iae.printStackTrace();
        } catch (InstantiationException ie) { ie.printStackTrace(); }
        session.setAttribute(Keys.TIMETABLE, t);
      }
      // dispatch to view of parameter forward
      if (mapping.findForward(forward) == null)
        return mapping.findForward("StartView");
      else
        return mapping.findForward(forward);
    }
    // dispatch to StartView
    else return mapping.findForward("StartView");


  }


}