package at.salzburgresearch.applications.trainreservation.actions;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import java.text.*;

import org.apache.struts.action.*;
import org.apache.struts.util.MessageResources;

import at.salzburgresearch.applications.trainreservation.datamodel.*;
import at.salzburgresearch.applications.trainreservation.actionforms.*;
import at.salzburgresearch.applications.trainreservation.db.*;
import at.salzburgresearch.applications.trainreservation.utils.*;

/**
 * Title: SelectTrainAction.java
 * Description: Struts-Action-Class for the SelectTrainAction
 * Copyright: Copyright (c) 2002
 * Company: Salzburg Research
 * @author Karl Rehrl
 * @version 1.0
 */

public class SelectTrainAction extends Action {

  /**
   * Called from the Struts-Controller-Servlet
   */
  public ActionForward perform(ActionMapping mapping,
                               ActionForm form,
                               HttpServletRequest request,
                               HttpServletResponse response)
    throws IOException, ServletException {

    // Extract attributes
    Locale locale = getLocale(request);
    MessageResources messages = getResources();
    HttpSession session = request.getSession();
    ActionErrors errors = new ActionErrors();

    // check if user is logged in and in the appropriate role for performing
    // the action
    if (!request.isUserInRole(Keys.TRAINRESERVATION_USER) || session.isNew())
      return mapping.findForward("Start");

    // get Parameters from ActionForm
    String action       = ((SelectTrainForm)form).getAction();
    String trainNum     = ((SelectTrainForm)form).getSelectedTrain();
    String travelDay    = ((SelectTrainForm)form).getDay();
    String travelMonth  = ((SelectTrainForm)form).getMonth();

    // debug
    Debug.print(this.getClass().getName(), "Action was: "+action);
    Debug.print(this.getClass().getName(), "selected train was: "+trainNum);
    Debug.print(this.getClass().getName(), "Selected day was: "+travelDay);
    Debug.print(this.getClass().getName(), "Selected month was: "+travelMonth);

    // get format travelDate
    String year =
      new Integer(Calendar.getInstance().get(Calendar.YEAR)).toString();
    String travelDate = travelDay+"."+travelMonth+"."+year;
    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
    Date date = null;
    try {
      date = df.parse(travelDate);
    } catch (ParseException pe) {
        errors.add("date_error", new ActionError("SelectTrainView.errors.date"));
    }
    travelDate = df.format(date);

    Debug.print(this.getClass().getName(), "TravelDate: "+travelDate);

    // get Coaches from DB
    ArrayList coaches = null;
    try {
      coaches = (ArrayList)((IDBAccess)Class.forName(Keys.DB_CLASS).
        newInstance()).getCoaches(trainNum);
    } catch (ClassNotFoundException cnfe) { cnfe.printStackTrace();
    } catch (IllegalAccessException iae) { iae.printStackTrace();
    } catch (InstantiationException ie) { ie.printStackTrace(); }

    Coach coach = null;
    if (coaches.size() != 0) {
      coach = (Coach)coaches.get(0);
      // set reserved seats
      try {
        coach.setReservedSeats(
          ((IDBAccess)Class.forName(Keys.DB_CLASS).newInstance()).
          getReservedSeatNums(trainNum, coach.getCoachNum(), travelDate));
      } catch (ClassNotFoundException cnfe) { cnfe.printStackTrace();
      } catch (IllegalAccessException iae) { iae.printStackTrace();
      } catch (InstantiationException ie) { ie.printStackTrace(); }
    }
    // no coach found, add error
    else
      errors.add("nocoaches_error",
                  new ActionError("SelectTrainView.errors.coach"));

    // set values to session
    session.setAttribute(Keys.TRAVELDATE, travelDate);
    session.setAttribute(Keys.TRAINNUM, trainNum);
    session.setAttribute(Keys.COACHES, coaches);
    session.setAttribute(Keys.COACH, coach);

    // set db-data to SelectSeats-Form if it exists in scope session
    if (session.getAttribute("SelectSeatsForm") != null)
      ((SelectSeatsForm)session.getAttribute("SelectSeatsForm")).setDBData(request);

    // report errors
    if (!errors.empty()) {
      saveErrors(request, errors);
      return (new ActionForward(mapping.getInput()));
    }

    // Remove the obsolete form bean
    if (mapping.getAttribute() != null) {
      if ("request".equals(mapping.getScope()))
        request.removeAttribute(mapping.getAttribute());
    }

    // Forward control to the specified next/back URI
    if (action != null &&
        action.equals(messages.getMessage(request.getLocale(), "SelectTrainView.next"))) {
      return (mapping.findForward("next"));
    }
    else return mapping.findForward("back");
  }

}