package at.salzburgresearch.applications.trainreservation.actions;

import java.io.*;
import java.util.*;
import java.text.*;
import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.struts.action.*;
import org.apache.struts.util.MessageResources;

import at.salzburgresearch.applications.trainreservation.datamodel.*;
import at.salzburgresearch.applications.trainreservation.actionforms.*;
import at.salzburgresearch.applications.trainreservation.db.*;
import at.salzburgresearch.applications.trainreservation.utils.*;

/**
 * Title: SelectSeatsAction.java
 * Description: Struts-Action-Class for reservation of seats
 * Copyright: Copyright (c) 2002
 * Company: Salzburg Research
 * @author Karl Rehrl
 * @version 1.0
 */

public class SelectSeatsAction extends Action {

  /**
   * Called from the Struts-Controller-Servlet
   */
  public ActionForward perform(ActionMapping mapping,
                               ActionForm form,
                               HttpServletRequest request,
                               HttpServletResponse response)
    throws IOException, ServletException {

    // Extract attributes
    Locale locale = getLocale(request);
    MessageResources messages = getResources();
    HttpSession session = request.getSession();
    ActionErrors errors = new ActionErrors();

    // define variable for forward
    String forward_mapping = null;

    // check if user is logged in and in the appropriate role for performing
    // the action
    if (!request.isUserInRole(Keys.TRAINRESERVATION_USER) || session.isNew())
      return mapping.findForward("Start");

    // get data of form
    String action   = ((SelectSeatsForm)form).getAction();
    String coachNum = ((SelectSeatsForm)form).getCoachNum();

    // get data from session
    String trainNum = (String)session.getAttribute(Keys.TRAINNUM);
    String travelDate = (String)session.getAttribute(Keys.TRAVELDATE);

    // Action reserve seats chosen
    if ((action != null) &&
        (action.equals(messages.getMessage(request.getLocale(), "SelectSeatsView.next")))) {

      Debug.print(this.getClass().getName(), "Action was "+
        messages.getMessage(request.getLocale(), "SelectSeatsView.next"));

      // get action specific data
      ArrayList checkedSeats = ((SelectSeatsForm)form).getCheckedSeats();

      // debug
      Iterator it = checkedSeats.iterator();
      while (it.hasNext()) {
        Seat s = (Seat)it.next();
        Debug.print(this.getClass().getName(),
          "Seat "+s.getSeatNum()+" was checked !");
      }

      if (checkedSeats.size() != 0) {

        // prepare data for reservation
        Reservation reservation = new Reservation();
        reservation.setTrainNum(trainNum);
        reservation.setCoachNum(coachNum);
        reservation.setUserName(request.getUserPrincipal().getName());
        reservation.setSeats(checkedSeats);
        // parse date
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        Date d = null;
        try {
          d = df.parse(travelDate);
        } catch (ParseException pe) {}
        reservation.setTravelDate(d);

        // save reservation
        IDBAccess dbaccess = null;
        try {
          dbaccess = ((IDBAccess)Class.forName(Keys.DB_CLASS).newInstance());
          dbaccess.saveReservation(reservation);

          request.setAttribute(Keys.RESERVATION, reservation);
          request.setAttribute(Keys.USER, (request.getUserPrincipal()).getName());
          session.invalidate();

          forward_mapping = "reservation";
        } catch (ClassNotFoundException cnfe) { cnfe.printStackTrace();
        } catch (IllegalAccessException iae) { iae.printStackTrace();
        } catch (InstantiationException ie) { ie.printStackTrace();
        } catch (DBException dbe) {
            Debug.print(this.getClass().getName(), "Seats not available Exception");
            errors.add("seatsnotavailable_error",
              new ActionError(dbe.getErrorKey()));
            Coach coach = (Coach)session.getAttribute(Keys.COACH);
            coach.setReservedSeats(dbaccess.getReservedSeatNums(
              trainNum, coachNum, travelDate));
            ((SelectSeatsForm)form).reset(mapping, request);
        }

      } else
          errors.add("noseats_error",
            new ActionError("SelectSeatsView.errors.seats"));


    // Action change coach chosen
    } else {
      Collection coaches = (Collection)session.getAttribute(Keys.COACHES);

      Debug.print(this.getClass().getName(), "Change coach to "+coachNum);

      if (coaches != null) {
        Iterator it = coaches.iterator();
        while (it.hasNext()) {
          Coach coach = (Coach)it.next();
          if (coachNum.equals(coach.getCoachNum())) {
            Debug.print(this.getClass().getName(),
              "Coach"+coach.getCoachNum()+" found");
            session.setAttribute(Keys.COACH, coach);
            // get reserved seats from db -> lazy load
            try {
              coach.setReservedSeats(
                ((IDBAccess)Class.forName(Keys.DB_CLASS).newInstance()).
                  getReservedSeatNums(trainNum, coachNum, travelDate));
            } catch (ClassNotFoundException cnfe) {
            } catch (IllegalAccessException iae) {
            } catch (InstantiationException ie) {}
            // set reserved seats in form
            ((SelectSeatsForm)form).setDBData(request); // Update der Daten
          }
        }
      }
      else
        errors.add("nocoaches_error",
          new ActionError("SelectSeatsView.errors.coach"));

      forward_mapping = "change_coach";
    }


    // Report errors
    if (!errors.empty()) {
      saveErrors(request, errors);
      return (new ActionForward(mapping.getInput()));
    }


    // Remove the obsolete form bean
    if (mapping.getAttribute() != null) {
      if ("request".equals(mapping.getScope()))
        request.removeAttribute(mapping.getAttribute());
    }

    // Forward control to the specified URI
    return (mapping.findForward(forward_mapping));
  }
}