package at.salzburgresearch.applications.trainreservation.actionforms;

import org.apache.struts.action.*;
import javax.servlet.http.*;
import javax.servlet.*;
import java.util.*;

/**
 * Title: SelectTrainForm.java
 * Description: Struts-Model for SelectTrainView.jsp
 * Copyright: Copyright (c) 2002
 * Company: Salzburg Research
 * @author Karl Rehrl
 * @version 1.0
 */

public class SelectTrainForm extends org.apache.struts.action.ActionForm {

  private String action = null; // action parameter of the form
  private String selectedTrain  = null;
  private String month          = null;
  private String day            = null;
  private ArrayList daysOfMonth = null; // read-only for use in the view

  public SelectTrainForm() {
  }

  // property action
  public void setAction(String action) {
    this.action = action;
  }
  public String getAction() {
    return action;
  }

  // property selectedTrain
  public void setSelectedTrain(String selectedTrain) {
    this.selectedTrain = selectedTrain;
  }
  public String getSelectedTrain() {
    return selectedTrain;
  }

  // property month
  public void setMonth(String month) {
    this.month = month;
  }
  public String getMonth() {
    return month;
  }

  // property day
  public void setDay(String day) {
    this.day = day;
  }
  public String getDay() {
    return day;
  }

  // property days of month
  public ArrayList getDaysOfMonth() {
    return daysOfMonth;
  }

  // static accessors for actual day and month
  public static String actualDay() {
    GregorianCalendar calendar = (GregorianCalendar)Calendar.getInstance();
    return new Integer(calendar.get(Calendar.DAY_OF_MONTH)).toString();
  }

  public static String actualMonth() {
    GregorianCalendar calendar = (GregorianCalendar)Calendar.getInstance();
    return new Integer(calendar.get(Calendar.MONTH)+1).toString();
  }

  public static String actualYear() {
    GregorianCalendar calendar = (GregorianCalendar)Calendar.getInstance();
    return new Integer(calendar.get(Calendar.YEAR)).toString();
  }


  /**
   * Resets the form data for reuse of the instance
   */
  public void reset(ActionMapping mapping, HttpServletRequest request) {
    selectedTrain = null;

    // determine days of actual month and add it to the ArrayList daysOfMonth
    GregorianCalendar calendar = (GregorianCalendar)Calendar.getInstance();
    int days = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
    System.out.println("DAYS: "+days);
    daysOfMonth = new ArrayList();
    for (int i=1; i <= days; i++) {
      daysOfMonth.add(new Integer(i).toString());
    }
  }


  /**
   * Validates the input-data of the form
   */
  public ActionErrors validate(ActionMapping mapping,
                               HttpServletRequest request) {

    ActionErrors errors = new ActionErrors();

    // no train selected
    if ((selectedTrain == null) || (selectedTrain.length() < 1))
      // add new ActionError with the internationalized error message from the
      // Resource Bundle
      errors.add("train_error", new ActionError("SelectTrainView.errors.train"));

    return errors;
  }
}