/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.PoolablePreparedStatement;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class PoolingConnection
extends DelegatingConnection
implements Connection,
KeyedPoolableObjectFactory {
    protected KeyedObjectPool _pstmtPool = null;

    public PoolingConnection(Connection connection) {
        super(connection);
    }

    public PoolingConnection(Connection connection, KeyedObjectPool keyedObjectPool) {
        super(connection);
        this._pstmtPool = keyedObjectPool;
    }

    public synchronized void close() throws SQLException {
        if (null != this._pstmtPool) {
            KeyedObjectPool keyedObjectPool = this._pstmtPool;
            this._pstmtPool = null;
            try {
                keyedObjectPool.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
        }
        this.getInnermostDelegate().close();
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(string));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(string, n, n2));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    protected Object createKey(String string, int n, int n2) {
        return new PStmtKey(this.normalizeSQL(string), n, n2);
    }

    protected Object createKey(String string) {
        return new PStmtKey(this.normalizeSQL(string));
    }

    protected String normalizeSQL(String string) {
        return string.trim();
    }

    public Object makeObject(Object object) {
        try {
            if (null == object || !(object instanceof PStmtKey)) {
                throw new IllegalArgumentException();
            }
            PStmtKey pStmtKey = (PStmtKey)object;
            if (null == pStmtKey._resultSetType && null == pStmtKey._resultSetConcurrency) {
                return new PoolablePreparedStatement(this.getDelegate().prepareStatement(pStmtKey._sql), pStmtKey, this._pstmtPool, this);
            }
            return new PoolablePreparedStatement(this.getDelegate().prepareStatement(pStmtKey._sql, pStmtKey._resultSetType, pStmtKey._resultSetConcurrency), pStmtKey, this._pstmtPool, this);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public void destroyObject(Object object, Object object2) {
        try {
            ((DelegatingPreparedStatement)object2).getInnermostDelegate().close();
        }
        catch (SQLException sQLException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            try {
                ((PreparedStatement)object2).close();
            }
            catch (SQLException sQLException) {
            }
            catch (ClassCastException classCastException2) {
                // empty catch block
            }
        }
    }

    public boolean validateObject(Object object, Object object2) {
        return true;
    }

    public void activateObject(Object object, Object object2) {
        ((DelegatingPreparedStatement)object2).activate();
    }

    public void passivateObject(Object object, Object object2) {
        try {
            ((PreparedStatement)object2).clearParameters();
            ((DelegatingPreparedStatement)object2).passivate();
        }
        catch (SQLException sQLException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public String toString() {
        return "PoolingConnection: " + this._pstmtPool.toString();
    }

    class PStmtKey {
        protected String _sql = null;
        protected Integer _resultSetType = null;
        protected Integer _resultSetConcurrency = null;

        PStmtKey(String string) {
            this._sql = string;
        }

        PStmtKey(String string, int n, int n2) {
            this._sql = string;
            this._resultSetType = new Integer(n);
            this._resultSetConcurrency = new Integer(n2);
        }

        public boolean equals(Object object) {
            try {
                PStmtKey pStmtKey = (PStmtKey)object;
                return (null == this._sql && null == pStmtKey._sql || this._sql.equals(pStmtKey._sql)) && (null == this._resultSetType && null == pStmtKey._resultSetType || this._resultSetType.equals(pStmtKey._resultSetType)) && (null == this._resultSetConcurrency && null == pStmtKey._resultSetConcurrency || this._resultSetConcurrency.equals(pStmtKey._resultSetConcurrency));
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        public int hashCode() {
            return null == this._sql ? 0 : this._sql.hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PStmtKey: sql=");
            stringBuffer.append(this._sql);
            stringBuffer.append(", resultSetType=");
            stringBuffer.append(this._resultSetType);
            stringBuffer.append(", resultSetConcurrency=");
            stringBuffer.append(this._resultSetConcurrency);
            return stringBuffer.toString();
        }
    }
}

