/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.nested;

import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.tagext.Tag;
import org.apache.struts.taglib.html.FormTag;
import org.apache.struts.taglib.nested.NestedNameSupport;
import org.apache.struts.taglib.nested.NestedParentSupport;
import org.apache.struts.taglib.nested.NestedPropertySupport;
import org.apache.struts.taglib.nested.NestedReference;
import org.apache.struts.taglib.nested.NestedTagSupport;

public class NestedPropertyHelper {
    public static final String NESTED_INCLUDES_KEY = "<nested-includes-key/>";

    public static final NestedReference setIncludeReference(HttpSession session, NestedReference reference) {
        NestedReference nr = (NestedReference)session.getAttribute(NESTED_INCLUDES_KEY);
        if (reference != null) {
            session.setAttribute(NESTED_INCLUDES_KEY, (Object)reference);
        } else {
            session.removeAttribute(NESTED_INCLUDES_KEY);
        }
        return nr;
    }

    public static Tag getNestingParentTag(NestedTagSupport tag) {
        Tag namedTag = (Tag)tag;
        Tag parentTag = null;
        do {
            namedTag = namedTag.getParent();
            if (parentTag != null || !(namedTag instanceof NestedParentSupport) && !(namedTag instanceof FormTag)) continue;
            parentTag = namedTag;
        } while (parentTag == null && namedTag != null);
        if (namedTag == null) {
            // empty if block
        }
        return parentTag;
    }

    public static String getNestedProperty(String property, Tag parentTag) {
        if (parentTag instanceof FormTag) {
            if (property.indexOf(47) == -1) {
                return property;
            }
            return property.substring(property.indexOf(47) + 1, property.length());
        }
        if (!(parentTag instanceof NestedParentSupport)) {
            // empty if block
        }
        NestedParentSupport nestedParent = (NestedParentSupport)parentTag;
        if ((property = property.indexOf(47) == -1 ? nestedParent.getNestedProperty() + "." + property : NestedPropertyHelper.getRelativeProperty(property, nestedParent.getNestedProperty())).startsWith(".")) {
            return property.substring(1, property.length());
        }
        return property;
    }

    public static String getNestedProperty(NestedPropertySupport tag) {
        Tag parentTag = NestedPropertyHelper.getNestingParentTag(tag);
        return NestedPropertyHelper.getNestedProperty(tag.getProperty(), parentTag);
    }

    public static String getNestedNameProperty(NestedTagSupport tag) {
        Tag namedTag = (Tag)tag;
        while ((namedTag = namedTag.getParent()) != null && !(namedTag instanceof FormTag) && !(namedTag instanceof NestedParentSupport)) {
        }
        if (namedTag == null) {
            // empty if block
        }
        String nameTemp = null;
        if (namedTag instanceof FormTag) {
            nameTemp = ((FormTag)namedTag).getName();
        } else if (namedTag instanceof NestedParentSupport) {
            nameTemp = ((NestedParentSupport)namedTag).getName();
        }
        return nameTemp;
    }

    public static void setNestedProperties(NestedPropertySupport tag) {
        String property = NestedPropertyHelper.getNestedProperty(tag);
        tag.setProperty(property);
        if (tag instanceof NestedNameSupport) {
            String name = NestedPropertyHelper.getNestedNameProperty(tag);
            ((NestedNameSupport)tag).setName(name);
        }
    }

    private static String getRelativeProperty(String property, String parent) {
        String stepping;
        if ("./".equals(property) || "this/".equals(property)) {
            return parent;
        }
        if (property.endsWith("/")) {
            stepping = property;
            property = "";
        } else {
            stepping = property.substring(0, property.lastIndexOf(47) + 1);
            property = property.substring(property.lastIndexOf(47) + 1, property.length());
        }
        if (stepping.startsWith("/")) {
            return property;
        }
        StringTokenizer proT = new StringTokenizer(parent, ".");
        int propCount = proT.countTokens();
        StringTokenizer strT = new StringTokenizer(stepping, "/");
        int count = strT.countTokens();
        if (count >= propCount) {
            return property;
        }
        count = propCount - count;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < count) {
            result.append(proT.nextToken());
            result.append('.');
            ++i;
        }
        result.append(property);
        if (result.charAt(result.length() - 1) == '.') {
            return result.substring(0, result.length() - 1);
        }
        return result.toString();
    }
}

