/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.actions;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.NoSuchDefinitionException;

public final class DefinitionDispatcherAction
extends Action {
    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String name;
        String parameter = mapping.getParameter();
        if (parameter == null) {
            parameter = "def";
        }
        if ((name = request.getParameter(parameter)) == null) {
            String msg = "Definition dispatcher action : can't get parameter '" + parameter + "'.";
            this.printError(response, msg);
            return null;
        }
        try {
            ComponentDefinition definition = DefinitionsUtil.getDefinition(name, (ServletRequest)request, this.getServlet().getServletContext());
            DefinitionsUtil.setActionDefinition((ServletRequest)request, definition);
        }
        catch (FactoryNotFoundException ex) {
            this.printError(response, "Error - DefinitionDispatcherAction : Can't get definition factory.");
            return mapping.findForward(null);
        }
        catch (NoSuchDefinitionException ex) {
            this.printError(response, "Error - DefinitionDispatcherAction : Can't get definition '" + name + "'.");
            return mapping.findForward(null);
        }
        catch (DefinitionsFactoryException ex) {
            this.printError(response, "Error - DefinitionDispatcherAction : General error '" + ex.getMessage() + "'.");
            return mapping.findForward(null);
        }
        return mapping.findForward(null);
    }

    protected void printError(HttpServletResponse response, String msg) throws IOException {
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        writer.println(msg);
        writer.flush();
        writer.close();
    }
}

