package com.iternum.micro.translator;

import org.ksoap.*;
import org.ksoap.transport.HttpTransport;
import java.util.Vector;
/**
 * <p>Title: SOAP Demo fr Java MIDP 1.0 und kSoap</p>
 * <p>Description: Proxy for the Translator Service. Uses
 * kSoap to connect to the server and retrieve the
 * translations.</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: iternum GmbH</p>
 * @author Karl F. Banke
 * @version 1.0
 */

public class TranslatorService {

  private static String URL = "http://www.iternum.net/soap/servlet/rpcrouter";
  public TranslatorService() {
  }

  /**
   *
   * @param term       The term to translate
   * @param srcLang    The language to translate from
   * @param targetLang The language to translate to
   * @return
   */
  public Vector retrieveTranslations(String term,String srcLang, String targetLang) {
    Vector        result    = null;
    HttpTransport transport = new HttpTransport(URL,"");
    transport.reset();
    SoapObject    request   = new SoapObject("urn:demo1:translate","getTranslations");
    ClassMap map     = new ClassMap(true);
    MarshalVector mv = new MarshalVector();
    mv.register(map);
    transport.setClassMap(map);
    request.addProperty("term",term);
    request.addProperty("srcLanguage",srcLang);
    request.addProperty("targetLanguage",targetLang);
    try {
      result = (Vector)transport.call(request);
      transport.reset();
    } catch (Exception exc) {
      System.err.println("Error executing soap call "+exc);
      System.err.println("Request was "+transport.requestDump);
      transport.reset();
      return new Vector();
    }
    return result;
  }
}