/*
 * Created by IntelliJ IDEA.
 * User: Lars Roewekamp
 * Date: 26.07.2002
 * Time: 14:28:20
 * To change template for new class use 
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package de.ix.wstutorial.currencyconverter;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.math.BigDecimal;

public class IXCurrencyConverter implements CurrencyConverter {


    /**
     * Umrechnung eines Wertes einer Originalwaehrung in den entsprechenden
     * Wert einer angegebenen Zielwaehrung.
     *
     * Zur Umrechnung werden zur Vereinfachung des Beispiels Konstanten herangezogen
     * und keine Datenbankwerte. Alle Konstanten beziehen sich auf den Einheitswert
     * EURO.
     *
     * @param value             Umzurechnender Wert
     * @param fromCurrency      Original Waehrung
     * @param toCurrency        Zielwaehrung
     * @return                  Umgerechneter Wert in neuer Zielwaehrung
     * @throws RemoteException  Remote Exception
     */
    public double convertCurrency(float value, String fromCurrency, String toCurrency) throws RemoteException {

        double fromValueBase   = 0.00;
        double toValueBase     = 0.00;

        double fromValueInEuro = 0.00;
        double toValue         = 0.00;

        /* Kurzform, wenn Ausgangswaehrung und Zielwaehrung identisch sind. */

        if (fromCurrency != null && fromCurrency.equals(toCurrency)) {
            return value;
        }


        CurrencyObject fromCurrencyObject = CurrencyMap.getCurrencyObject(fromCurrency);
        CurrencyObject toCurrencyObject   = CurrencyMap.getCurrencyObject(toCurrency);


        if (fromCurrencyObject != null) {
            fromValueBase   = fromCurrencyObject.getValue();
        } else {
            throw new RemoteException();
        }

        if (toCurrencyObject != null) {
            toValueBase   = toCurrencyObject.getValue();
        } else {
            throw new RemoteException();
        }

        /* Euro Wert als gemeinsame Basis ermitteln */

        fromValueInEuro = value / fromValueBase;

        /* Neuen Wert mit Hilfe des Euro Wertes errechnen */

        toValue         = fromValueInEuro * toValueBase;

        return toValue;

    }

}
