/*
 * Created by IntelliJ IDEA.
 * User: Lars Roewekamp
 * Date: 05.09.2002
 * Time: 18:42:39
 * To change template for new class use 
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package de.ix.wstutorial.currencyconverter;

import java.util.*;
import java.math.BigDecimal;

public class CurrencyMap {

    private static SortedMap currencyMap = null;

    private final static CurrencyObject BEF_CURRENCY = new CurrencyObject("BEF", "Belgien",      "Belgische Franc",           40.3399,  true);
    private final static CurrencyObject DEM_CURRENCY = new CurrencyObject("DEM", "Deutschland",  "Deutsche Mark",             1.95583,  true);
    private final static CurrencyObject FIM_CURRENCY = new CurrencyObject("FIM", "Finnland",     "Finnmark",                  5.94573,  true);
    private final static CurrencyObject FRF_CURRENCY = new CurrencyObject("FRF", "Frankreich",   "Franzsische Franc",        6.55957,  true);
    private final static CurrencyObject GRD_CURRENCY = new CurrencyObject("GRD", "Griechenland", "Griechische Drachme",       340.750,  true);
    private final static CurrencyObject IEP_CURRENCY = new CurrencyObject("IEP", "Irland",       "Irische Pfund",             0.787564, true);
    private final static CurrencyObject ITL_CURRENCY = new CurrencyObject("ITL", "Italien",      "Italienische Lira",         1936.27,  true);
    private final static CurrencyObject LUF_CURRENCY = new CurrencyObject("LUF", "Luxenburg",    "Luxenburgische Franc",      40.3399,  true);
    private final static CurrencyObject NLG_CURRENCY = new CurrencyObject("NLG", "Niederlande",  "Niederlndische Gulden",    2.20371,  true);
    private final static CurrencyObject ATS_CURRENCY = new CurrencyObject("ATS", "sterreich",   "sterreichische Schilling", 13.7603,  true);
    private final static CurrencyObject PTE_CURRENCY = new CurrencyObject("PTE", "Portugal",     "Portugisische Escudo",      200.482,  true);
    private final static CurrencyObject ESP_CURRENCY = new CurrencyObject("ESP", "Spanien",      "Spanische Peseta",          166.386,  true);

    private final static CurrencyObject USD_CURRENCY = new CurrencyObject("USD", "USA",          "US Dollar",                 0.9914,   false);
    private final static CurrencyObject GBP_CURRENCY = new CurrencyObject("GBP", "Grobritanien","Britische Pfund",           0.6362,   false);
    private final static CurrencyObject JPY_CURRENCY = new CurrencyObject("JPY", "Japan",        "Japanische Yen",            116.27,   false);
    private final static CurrencyObject CHF_CURRENCY = new CurrencyObject("CHF", "Schweiz",      "Schweizer Franken",         1.4697,   false);
    private final static CurrencyObject DKK_CURRENCY = new CurrencyObject("DKK", "Dnemark",     "Dnische Kronen",           7.4254,   false);
    private final static CurrencyObject SEK_CURRENCY = new CurrencyObject("SEK", "Schweden",     "Schwedische Kronen",        9.2755,   false);
    private final static CurrencyObject NOK_CURRENCY = new CurrencyObject("NOK", "Norwegen",     "Norwegische Kronen",        7.4360,   false);
    private final static CurrencyObject CAD_CURRENCY = new CurrencyObject("CAD", "Canada",       "Canadische Dollar",         1.5406,   false);
    private final static CurrencyObject AUD_CURRENCY = new CurrencyObject("AUD", "Australien",   "Australische Dollar",       1.8015,   false);
    private final static CurrencyObject NZD_CURRENCY = new CurrencyObject("NZD", "Neuseeland",   "Neuseelndische Dollar",    2.1034,   false);
    private final static CurrencyObject HKD_CURRENCY = new CurrencyObject("HKD", "Hong Kong",    "Hong Kong Dollar",          7.7296,   false);
    private final static CurrencyObject SGD_CURRENCY = new CurrencyObject("SGD", "Singapore",    "Singapore Dollar",          1.7306,   false);
    private final static CurrencyObject MYR_CURRENCY = new CurrencyObject("MYR", "Malaysia",     "Malaysische Ringgit",       3.7663,   false);
    private final static CurrencyObject ZAR_CURRENCY = new CurrencyObject("ZAR", "Sdafrika",    "Sdafrikanische Rand",      10.5657,  false);
    private final static CurrencyObject EUR_CURRENCY = new CurrencyObject("EUR", "Euro-Lnder",  "Euro",                      1.00,     true);

    /**
     *
     *
     * @return
     */
    public static CurrencyObject getCurrencyObject(String code) {
        if (currencyMap == null) {
          initCurrencyMap();
        }
        return (CurrencyObject)currencyMap.get(code);
    }

    /**
     *
     *
     * @return
     */
    public static Iterator getKeyIterator() {
        if (currencyMap == null) {
          initCurrencyMap();
        }
        Set keySet = currencyMap.keySet();
        if (keySet != null)
          return keySet.iterator();
        else
          return null;
    }



    /**
     *
     *
     * @return
     */
    public static SortedMap getCurrencyMap() {
        if (currencyMap == null) {
          initCurrencyMap();
        }
        return currencyMap;
    }


    private static void initCurrencyMap() {
        currencyMap = new TreeMap();
        currencyMap.put(BEF_CURRENCY.getCode(), BEF_CURRENCY);
        currencyMap.put(DEM_CURRENCY.getCode(), DEM_CURRENCY);
        currencyMap.put(FIM_CURRENCY.getCode(), FIM_CURRENCY);
        currencyMap.put(FRF_CURRENCY.getCode(), FRF_CURRENCY);
        currencyMap.put(GRD_CURRENCY.getCode(), GRD_CURRENCY);
        currencyMap.put(IEP_CURRENCY.getCode(), IEP_CURRENCY);
        currencyMap.put(ITL_CURRENCY.getCode(), ITL_CURRENCY);
        currencyMap.put(LUF_CURRENCY.getCode(), LUF_CURRENCY);
        currencyMap.put(NLG_CURRENCY.getCode(), NLG_CURRENCY);
        currencyMap.put(ATS_CURRENCY.getCode(), ATS_CURRENCY);
        currencyMap.put(PTE_CURRENCY.getCode(), PTE_CURRENCY);
        currencyMap.put(ESP_CURRENCY.getCode(), ESP_CURRENCY);


        currencyMap.put(USD_CURRENCY.getCode(), USD_CURRENCY);
        currencyMap.put(GBP_CURRENCY.getCode(), GBP_CURRENCY);
        currencyMap.put(JPY_CURRENCY.getCode(), JPY_CURRENCY);
        currencyMap.put(CHF_CURRENCY.getCode(), CHF_CURRENCY);
        currencyMap.put(DKK_CURRENCY.getCode(), DKK_CURRENCY);
        currencyMap.put(SEK_CURRENCY.getCode(), SEK_CURRENCY);
        currencyMap.put(NOK_CURRENCY.getCode(), NOK_CURRENCY);
        currencyMap.put(CAD_CURRENCY.getCode(), CAD_CURRENCY);
        currencyMap.put(AUD_CURRENCY.getCode(), AUD_CURRENCY);
        currencyMap.put(NZD_CURRENCY.getCode(), NZD_CURRENCY);
        currencyMap.put(HKD_CURRENCY.getCode(), HKD_CURRENCY);
        currencyMap.put(SGD_CURRENCY.getCode(), SGD_CURRENCY);
        currencyMap.put(MYR_CURRENCY.getCode(), MYR_CURRENCY);
        currencyMap.put(ZAR_CURRENCY.getCode(), ZAR_CURRENCY);
        currencyMap.put(EUR_CURRENCY.getCode(), EUR_CURRENCY);

    }



}
