/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.ant;

import com.sun.xml.rpc.tools.xrpcc.Main;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Xrpcc
extends MatchingTask {
    protected boolean both = true;
    protected Path compileClasspath = null;
    protected boolean client = false;
    private File baseDir = null;
    private File sourceBase;
    private boolean debug = false;
    private boolean keep = false;
    private boolean noWarn = false;
    protected boolean server = false;
    protected boolean verbose = false;
    protected boolean version = false;
    private String XActionsFile = null;
    protected boolean xDHOnly = false;
    protected boolean xExplicitContext = false;
    private String HTTPProxyURL = null;
    private URL proxyURL = null;
    protected boolean xImport = false;
    protected boolean xModel = false;
    private String xModelFile = null;
    protected boolean xNoCompile = false;
    protected boolean xNoDataBinding = false;
    protected boolean xNoEncodedTypes = false;
    protected boolean xNoMultiRefs = false;
    protected boolean xNoValidation = false;
    protected boolean xPrintStackTrace = false;
    protected boolean xSerializeIF = false;
    protected boolean xSearchSchema = false;
    private String XMLModelFile = null;
    private File config;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;

    public boolean getBoth() {
        return this.both;
    }

    public void setBoth(boolean both) {
        this.both = both;
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(((ProjectComponent)this).project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public boolean getClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
        this.setBoth(false);
    }

    public File getBase() {
        return this.baseDir;
    }

    public void setBase(File base) {
        this.baseDir = base;
    }

    public void setSourceBase(File sourceBase) {
        this.keep = true;
        this.sourceBase = sourceBase;
    }

    public File getSourceBase() {
        return this.sourceBase;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean getNoWarn() {
        return this.noWarn;
    }

    public void setNoWarn(boolean noWarn) {
        this.noWarn = noWarn;
    }

    public boolean getServer() {
        return this.server;
    }

    public void setServer(boolean server) {
        this.server = server;
        this.setBoth(false);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public String getXActionsFile() {
        return this.XActionsFile;
    }

    public void setXActionsFile(String XActionsFile) {
        this.XActionsFile = XActionsFile;
    }

    public boolean getXDataHandlerOnly() {
        return this.xDHOnly;
    }

    public void setXDataHandlerOnly(boolean xDHOnly) {
        this.xDHOnly = xDHOnly;
    }

    public boolean getXExplicitContext() {
        return this.xExplicitContext;
    }

    public void setXExplicitContext(boolean xExplicitContext) {
        this.xExplicitContext = xExplicitContext;
    }

    public String getXHTTPProxy() {
        return this.HTTPProxyURL;
    }

    public void setXHTTPProxy(String HTTPProxy) {
        if (HTTPProxy != null && !HTTPProxy.equals("")) {
            this.HTTPProxyURL = HTTPProxy.startsWith("http://") ? HTTPProxy : "http://" + HTTPProxy;
            try {
                URL proxyServer = new URL(this.HTTPProxyURL);
                this.setProxyServer(proxyServer);
            }
            catch (MalformedURLException e) {
                throw new Error("Invalid HTTP URL specified: " + this.HTTPProxyURL);
            }
        }
    }

    public URL getProxyServer() {
        return this.proxyURL;
    }

    public void setProxyServer(URL proxyURL) {
        this.proxyURL = proxyURL;
    }

    public boolean getXImport() {
        return this.xImport;
    }

    public void setXImport(boolean xImport) {
        this.xImport = xImport;
    }

    public boolean getXModel() {
        return this.xModel;
    }

    public void setXModel(boolean xModel) {
        this.xModel = xModel;
    }

    public String getXModelFile() {
        return this.xModelFile;
    }

    public void setXModelFile(String xModelFile) {
        this.xModelFile = xModelFile;
        this.setXModel(true);
    }

    public boolean getXNoCompile() {
        return this.xNoCompile;
    }

    public void setXNoCompile(boolean xNoCompile) {
        this.xNoCompile = xNoCompile;
    }

    public boolean getXNoDataBinding() {
        return this.xNoDataBinding;
    }

    public void setXNoDataBinding(boolean xNoDataBinding) {
        this.xNoDataBinding = xNoDataBinding;
    }

    public boolean getXNoEncodedTypes() {
        return this.xNoEncodedTypes;
    }

    public void setXNoEncodedTypes(boolean xNoEncodedTypes) {
        this.xNoEncodedTypes = xNoEncodedTypes;
    }

    public boolean getXNoMultiRefs() {
        return this.xNoMultiRefs;
    }

    public void setXNoMultiRefs(boolean xNoMultiRefs) {
        this.xNoMultiRefs = xNoMultiRefs;
    }

    public boolean getXNoValidation() {
        return this.xNoValidation;
    }

    public void setXNoValidation(boolean xNoValidation) {
        this.xNoValidation = xNoValidation;
    }

    public boolean getXPrintStackTrace() {
        return this.xPrintStackTrace;
    }

    public void setXPrintStackTrace(boolean xPrintStackTrace) {
        this.xPrintStackTrace = xPrintStackTrace;
    }

    public boolean getXSerializeInterfaces() {
        return this.xSerializeIF;
    }

    public void setXSerializeInterfaces(boolean xSerializeInterfaces) {
        this.xSerializeIF = xSerializeInterfaces;
    }

    public boolean getXSearchSchema() {
        return this.xSearchSchema;
    }

    public void setXSearchSchema(boolean xSearchSchema) {
        this.xSearchSchema = xSearchSchema;
    }

    public String getXMLModelFile() {
        return this.XMLModelFile;
    }

    public void setXMLModelFile(String XMLModelFile) {
        this.XMLModelFile = XMLModelFile;
    }

    public File getConfig() {
        return this.config;
    }

    public void setConfig(File config) {
        this.config = config;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    private Path generateCompileClasspath() {
        Path classpath = new Path(this.getProject());
        if (this.getClasspath() == null) {
            if (this.getIncludeantruntime()) {
                classpath.addExisting(Path.systemClasspath);
            }
        } else if (this.getIncludeantruntime()) {
            classpath.addExisting(this.getClasspath().concatSystemClasspath("last"));
        } else {
            classpath.addExisting(this.getClasspath().concatSystemClasspath("ignore"));
        }
        if (this.getIncludejavaruntime()) {
            classpath.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            classpath.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
        }
        return classpath;
    }

    private Commandline setupXrpccCommand(String[] options) {
        String host;
        Commandline cmd = new Commandline();
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                cmd.createArgument().setValue(options[i]);
                ++i;
            }
        }
        if (this.getBoth()) {
            cmd.createArgument().setValue("-both");
        } else if (this.getClient()) {
            cmd.createArgument().setValue("-client");
        } else if (this.getServer()) {
            cmd.createArgument().setValue("-server");
        }
        Path classpath = this.getClasspath();
        if (classpath != null && !classpath.toString().equals("")) {
            cmd.createArgument().setValue("-classpath");
            cmd.createArgument().setPath(classpath);
        }
        if (null != this.getBase() && !this.getBase().equals("")) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.getBase());
        }
        if (null != this.getSourceBase() && !this.getSourceBase().equals("")) {
            cmd.createArgument().setValue("-s");
            cmd.createArgument().setFile(this.getSourceBase());
        }
        if (this.getDebug()) {
            cmd.createArgument().setValue("-g");
        }
        if (this.getKeep()) {
            cmd.createArgument().setValue("-keep");
        }
        if (this.getNoWarn()) {
            cmd.createArgument().setValue("-nowarn");
        }
        if (this.getVerbose()) {
            cmd.createArgument().setValue("-verbose");
        }
        if (this.getVersion()) {
            cmd.createArgument().setValue("-version");
        }
        if (this.getXActionsFile() != null && !this.getXActionsFile().equals("")) {
            cmd.createArgument().setValue("-Xactions:" + this.getXActionsFile());
        }
        if (this.getXDataHandlerOnly()) {
            cmd.createArgument().setValue("-Xdatahandleronly");
        }
        if (this.getXExplicitContext()) {
            cmd.createArgument().setValue("-Xexplicitcontext");
        }
        if (this.getProxyServer() != null && (host = this.getProxyServer().getHost()) != null && !host.equals("")) {
            String proxyVal = "-Xhttpproxy:" + host;
            if (this.getProxyServer().getPort() != -1) {
                proxyVal = proxyVal + ":" + this.getProxyServer().getPort();
            }
            cmd.createArgument().setValue(proxyVal);
        }
        if (this.getXImport()) {
            cmd.createArgument().setValue("-Ximport");
        }
        if (this.getXModel()) {
            String modelVal = "-Xmodel";
            if (this.getXModelFile() != null && !this.getXModelFile().equals("")) {
                modelVal = modelVal + ":" + this.getXModelFile();
            }
            cmd.createArgument().setValue(modelVal);
        }
        if (this.getXNoCompile()) {
            cmd.createArgument().setValue("-Xnocompile");
        }
        if (this.getXNoDataBinding()) {
            cmd.createArgument().setValue("-Xnodatabinding");
        }
        if (this.getXNoEncodedTypes()) {
            cmd.createArgument().setValue("-Xnoencodedtypes");
        }
        if (this.getXNoMultiRefs()) {
            cmd.createArgument().setValue("-Xnomultirefs");
        }
        if (this.getXNoValidation()) {
            cmd.createArgument().setValue("-Xnovalidation");
        }
        if (this.getXPrintStackTrace()) {
            cmd.createArgument().setValue("-Xprintstacktrace");
        }
        if (this.getXSerializeInterfaces()) {
            cmd.createArgument().setValue("-Xserializeinterfaces");
        }
        if (this.getXSearchSchema()) {
            cmd.createArgument().setValue("-Xsearchschema");
        }
        if (this.getXMLModelFile() != null && !this.getXMLModelFile().equals("")) {
            cmd.createArgument().setValue("-Xxmodel:" + this.getXMLModelFile());
        }
        cmd.createArgument().setValue(this.config.toString());
        return cmd;
    }

    private Commandline setupXrpccCommand() {
        return this.setupXrpccCommand(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (!this.getVersion()) {
            if (this.getConfig() == null) throw new BuildException("xrpcc config file does not exist!", ((Task)this).location);
            if (!this.getConfig().exists()) {
                throw new BuildException("xrpcc config file does not exist!", ((Task)this).location);
            }
        }
        Commandline cmd = this.setupXrpccCommand();
        if (this.verbose) {
            this.log("command line: xrpcc " + cmd.toString());
        }
        LogOutputStream logstr = new LogOutputStream((Task)this, 1);
        try {
            try {
                Main main = new Main((OutputStream)logstr, "xrpcc");
                boolean ok = main.compile(cmd.getArguments());
                if (!ok) {
                    if (this.verbose) throw new BuildException("xrpcc failed", ((Task)this).location);
                    this.log("Command invoked: xrpcc " + cmd.toString());
                    throw new BuildException("xrpcc failed", ((Task)this).location);
                }
                Object var6_6 = null;
            }
            catch (Exception ex) {
                if (!(ex instanceof BuildException)) throw new BuildException("Error starting xrpcc: ", (Throwable)ex, this.getLocation());
                throw (BuildException)ex;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                logstr.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        logstr.close();
    }
}

