/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.exporter;

import com.sun.xml.rpc.processor.util.PrettyPrintingXMLWriterFactoryImpl;
import com.sun.xml.rpc.streaming.PrefixFactoryImpl;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.GZIPOutputStream;
import javax.xml.namespace.QName;

public abstract class ExporterBase {
    protected OutputStream out;
    protected XMLWriter writer;
    protected Map obj2id;
    protected int nextId;
    protected Set obj2serialize;
    protected Stack obj2serializeStack;
    protected Set immediateClasses;
    protected static final QName DEF_OBJ_NAME = new QName("object");
    protected static final QName DEF_IMM_OBJ_NAME = new QName("iobject");
    protected static final QName PROP_NAME = new QName("property");
    protected static final String ATTR_VERSION = "version";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_SUBJECT = "subject";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$com$sun$xml$rpc$wsdl$document$soap$SOAPStyle;

    public ExporterBase(OutputStream s) {
        this.out = s;
        try {
            this.writer = new PrettyPrintingXMLWriterFactoryImpl().createXMLWriter(new GZIPOutputStream(s));
        }
        catch (IOException e) {
            throw new XMLWriterException("xmlwriter.ioException", new LocalizableExceptionAdapter(e));
        }
        this.writer.setPrefixFactory(new PrefixFactoryImpl("ns"));
    }

    protected void initialize() {
        this.obj2id = new HashMap();
        this.obj2serialize = new HashSet();
        this.obj2serializeStack = new Stack();
        this.nextId = 1;
        this.immediateClasses = new HashSet();
        this.immediateClasses.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ExporterBase.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.immediateClasses.add(class$java$lang$Integer == null ? (class$java$lang$Integer = ExporterBase.class$("java.lang.Integer")) : class$java$lang$Integer);
        try {
            this.immediateClasses.add(Class.forName("[I"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.immediateClasses.add(class$java$lang$String == null ? (class$java$lang$String = ExporterBase.class$("java.lang.String")) : class$java$lang$String);
        this.immediateClasses.add(class$java$util$ArrayList == null ? (class$java$util$ArrayList = ExporterBase.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        this.immediateClasses.add(class$java$util$HashSet == null ? (class$java$util$HashSet = ExporterBase.class$("java.util.HashSet")) : class$java$util$HashSet);
        this.immediateClasses.add(class$java$util$HashMap == null ? (class$java$util$HashMap = ExporterBase.class$("java.util.HashMap")) : class$java$util$HashMap);
        this.immediateClasses.add(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ExporterBase.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        this.immediateClasses.add(class$com$sun$xml$rpc$wsdl$document$soap$SOAPStyle == null ? (class$com$sun$xml$rpc$wsdl$document$soap$SOAPStyle = ExporterBase.class$("com.sun.xml.rpc.wsdl.document.soap.SOAPStyle")) : class$com$sun$xml$rpc$wsdl$document$soap$SOAPStyle);
    }

    protected void internalDoExport(Object root) {
        this.initialize();
        this.writer.startElement(this.getContainerName());
        if (this.getVersion() != null) {
            this.writer.writeAttribute(ATTR_VERSION, this.getVersion());
        }
        int id = this.getId(root);
        while (!this.obj2serializeStack.empty()) {
            Object obj = this.obj2serializeStack.pop();
            this.obj2serialize.remove(obj);
            this.visit(obj);
        }
        this.writer.endElement();
        this.writer.close();
    }

    protected void visit(Object obj) {
        if (obj == null) {
            return;
        }
        this.failUnsupportedClass(obj.getClass());
    }

    protected boolean isImmediate(Object obj) {
        if (obj == null) {
            return true;
        }
        return this.immediateClasses.contains(obj.getClass());
    }

    protected int getId(Object obj) {
        if (obj == null) {
            return 0;
        }
        Integer id = (Integer)this.obj2id.get(obj);
        if (id != null) {
            return id;
        }
        id = this.newId();
        this.obj2id.put(obj, id);
        if (this.isImmediate(obj)) {
            this.defineImmediate(obj, id);
        } else {
            this.define(obj, id);
        }
        return id;
    }

    protected void defineImmediate(Object obj, Integer id) {
        String value = this.getImmediateObjectValue(obj);
        this.writer.startElement(this.getDefineImmediateObjectName());
        this.writer.writeAttribute(ATTR_ID, id.toString());
        this.writer.writeAttribute(ATTR_TYPE, obj.getClass().getName());
        this.writer.writeAttribute(ATTR_VALUE, value);
        this.writer.endElement();
    }

    protected String getImmediateObjectValue(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof QName) {
            return obj.toString();
        }
        if (obj instanceof Integer) {
            return obj.toString();
        }
        if (obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof SOAPStyle) {
            return obj == SOAPStyle.RPC ? "rpc" : "document";
        }
        if (obj instanceof int[]) {
            int[] a = (int[])obj;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < a.length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(a[i]));
                ++i;
            }
            return sb.toString();
        }
        if (obj instanceof ArrayList) {
            ArrayList a = (ArrayList)obj;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            Iterator iter = ((AbstractList)a).iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!first) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(this.getId(element)));
                first = false;
            }
            return sb.toString();
        }
        if (obj instanceof HashSet) {
            HashSet s = (HashSet)obj;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!first) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(this.getId(element)));
                first = false;
            }
            return sb.toString();
        }
        if (obj instanceof HashMap) {
            HashMap m = (HashMap)obj;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!first) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(this.getId(entry.getKey())));
                sb.append(' ');
                sb.append(Integer.toString(this.getId(entry.getValue())));
                first = false;
            }
            return sb.toString();
        }
        this.failUnsupportedClass(obj.getClass());
        return "UNKOWN";
    }

    protected void define(Object obj, Integer id) {
        this.writer.startElement(this.getDefineObjectName());
        this.writer.writeAttribute(ATTR_ID, id.toString());
        this.writer.writeAttribute(ATTR_TYPE, obj.getClass().getName());
        this.writer.endElement();
        this.obj2serialize.add(obj);
        this.obj2serializeStack.push(obj);
    }

    protected void property(String name, Object subject, Object object) {
        int sid = this.getId(subject);
        int oid = this.getId(object);
        this.writer.startElement(this.getPropertyName());
        this.writer.writeAttribute(ATTR_NAME, name);
        this.writer.writeAttribute(ATTR_SUBJECT, Integer.toString(sid));
        this.writer.writeAttribute(ATTR_VALUE, Integer.toString(oid));
        this.writer.endElement();
    }

    protected Integer newId() {
        return new Integer(this.nextId++);
    }

    protected abstract QName getContainerName();

    protected String getVersion() {
        return null;
    }

    protected QName getDefineObjectName() {
        return DEF_OBJ_NAME;
    }

    protected QName getDefineImmediateObjectName() {
        return DEF_IMM_OBJ_NAME;
    }

    protected QName getPropertyName() {
        return PROP_NAME;
    }

    protected abstract void failUnsupportedClass(Class var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

