/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.ArraySerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.CollectionSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.CustomSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.DynamicSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.EnumerationSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.InterfaceSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.LiteralFragmentSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.LiteralSequenceSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.LiteralSimpleSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SOAPObjectSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactory;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class SerializerWriterFactoryImpl
implements SerializerWriterFactory {
    private Map writerMap = new HashMap();
    private Names names;

    public SerializerWriterFactoryImpl(Names names) {
        this.names = names;
    }

    public SerializerWriter createWriter(AbstractType type) {
        SerializerWriter writer = this.getTypeSerializerWriter(type);
        if (writer == null) {
            if (type instanceof SOAPAnyType) {
                writer = new DynamicSerializerWriter((SOAPType)type, this.names);
            } else if (type instanceof SOAPSimpleType) {
                writer = CollectionSerializerWriter.handlesType(type) ? new CollectionSerializerWriter((SOAPType)type, this.names) : new SimpleTypeSerializerWriter((SOAPType)type, this.names);
            } else if (type instanceof SOAPStructureType) {
                writer = ((SOAPStructureType)type).getSubtypes() != null ? new InterfaceSerializerWriter((SOAPType)type, this.names) : new SOAPObjectSerializerWriter((SOAPType)type, this.names);
            } else if (type instanceof SOAPArrayType) {
                writer = new ArraySerializerWriter((SOAPType)type, this.names);
            } else if (type instanceof SOAPEnumerationType) {
                writer = new EnumerationSerializerWriter((SOAPType)type, this.names);
            } else if (type instanceof SOAPCustomType) {
                writer = new CustomSerializerWriter((SOAPType)type, this.names);
            } else if (type instanceof LiteralFragmentType) {
                writer = new LiteralFragmentSerializerWriter((LiteralFragmentType)type, this.names);
            } else if (type instanceof LiteralSimpleType) {
                writer = new LiteralSimpleSerializerWriter((LiteralSimpleType)type, this.names);
            } else if (type instanceof LiteralSequenceType) {
                writer = new LiteralSequenceSerializerWriter((LiteralSequenceType)type, this.names);
            } else if (type instanceof LiteralAllType) {
                writer = new LiteralSequenceSerializerWriter((LiteralAllType)type, this.names);
            }
            if (writer == null) {
                throw new GeneratorException("generator.unsupported.type.encountered", new Object[]{type.getName().getLocalPart(), type.getName().getNamespaceURI()});
            }
            this.setTypeSerializerWriter(type, writer);
        }
        return writer;
    }

    private SerializerWriter getTypeSerializerWriter(AbstractType type) {
        String key = SerializerWriterFactoryImpl.genKey(type.getName(), type.getJavaType().getName());
        SerializerWriter writer = (SerializerWriter)this.writerMap.get(key);
        return writer;
    }

    private void setTypeSerializerWriter(AbstractType type, SerializerWriter writer) {
        String key = SerializerWriterFactoryImpl.genKey(type.getName(), type.getJavaType().getName());
        this.writerMap.put(key, writer);
    }

    protected static String genKey(QName schemaType, String javaType) {
        return schemaType + ";" + javaType;
    }
}

