/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.LiteralEncoding;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public abstract class StubTieGeneratorBase
extends GeneratorBase {
    protected Port port;
    protected HashSet operations = null;
    protected Set types;
    protected Map portTypes;
    private String prefix;
    protected File srcFile;

    public StubTieGeneratorBase() {
    }

    protected String getPrefix() {
        return "";
    }

    protected abstract String getClassName();

    protected abstract String getStateType();

    protected abstract Message getMessageToDeserialize(Operation var1);

    protected abstract String getStateGetRequestResponseString();

    protected abstract String getInitializeAccess();

    protected abstract boolean superClassHasInitialize();

    protected StubTieGeneratorBase(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
        this.prefix = this.getPrefix();
        this.srcFile = null;
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    protected void preVisitPort(Port port) throws Exception {
        this.operations = new HashSet();
        this.portTypes = new HashMap();
        this.port = port;
    }

    protected void postVisitPort(Port port) throws Exception {
        this.writeClass();
        this.port = null;
        this.portTypes = null;
        this.operations = null;
    }

    protected void postVisitOperation(Operation operation) throws Exception {
        this.operations.add(operation);
    }

    protected void responseBodyBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void responseHeaderBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void requestBodyBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void requestHeaderBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    protected void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    protected void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    private void registerBlock(Block block) {
        String key = null;
        if (block.getType().isSOAPType()) {
            key = block.getType().getJavaType().getRealName();
        } else if (block.getType().isLiteralType()) {
            key = block.getType().getName().toString() + block.getType().getJavaType().getRealName();
        }
        if (!this.portTypes.containsKey(key)) {
            this.portTypes.put(key, block);
        }
    }

    private boolean isRegistered(AbstractType type) {
        return this.types.contains(type);
    }

    private void registerType(AbstractType type) {
        this.types.add(type);
    }

    protected void writeClass() {
        String remoteClassName = this.port.getJavaInterface().getName();
        String className = this.getClassName();
        this.srcFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
        this.env.addGeneratedFile(this.srcFile);
        try {
            this.out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.srcFile)));
            GeneratorBase.writePackage(this.out, className);
            this.writeImports(this.out);
            this.out.pln();
            this.writeClassDecl(this.out, className);
            this.out.pln();
            this.writeConstructor(this.out, className);
            this.out.pln();
            this.writeOperations(this.out, remoteClassName);
            this.out.pln();
            this.writePeekFirstBodyElementMethod(this.out);
            this.out.pln();
            this.writeReadFirstBodyElement(this.out);
            this.out.pln();
            Map headerMap = this.writeReadHeaderElementMethod(this.out);
            this.out.pln();
            this.writeHeaderDeserializeMethods(this.out, headerMap.values().iterator());
            this.out.pln();
            this.writeOperationDeserializeMethods(this.out);
            this.out.pln();
            this.writeReadBodyFaultElement(this.out);
            this.out.pln();
            this.writeProcessingHookMethod(this.out);
            this.out.pln();
            this.writeGenericMethods(this.out);
            this.out.pln();
            this.writeGetNamespaceDeclarationsMethod(this.out);
            this.out.pln();
            this.writeGetUnderstoodHeadersMethod(this.out);
            this.out.pln();
            this.writeInitialize(this.out);
            this.out.pln();
            this.writeStaticMembers(this.out, headerMap);
            this.out.pln();
            this.writeUnderstoodHeadersMember(this.out, headerMap);
            this.closeSrcFile();
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", this.port.getName().getLocalPart());
        }
    }

    protected void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.streaming.*;");
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        p.pln("import com.sun.xml.rpc.encoding.literal.*;");
        p.pln("import com.sun.xml.rpc.soap.streaming.*;");
        p.pln("import com.sun.xml.rpc.soap.message.*;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.namespace.QName;");
        p.pln("import java.rmi.RemoteException;");
        p.pln("import java.util.Iterator;");
    }

    protected void writeClassDecl(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.pln(stringBuffer.append(Names.mangleClass(className)).toString());
        p.pln(" {");
        p.pln();
    }

    protected void writeConstructor(IndentingWriter p, String stubClassName) throws IOException {
        p.pln("/*");
        p.pln(" *  public constructor");
        p.pln(" */");
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(stubClassName)).append("() {").toString());
        p.pOln("}");
    }

    protected void writeOperations(IndentingWriter p, String remoteClassName) throws IOException {
        Iterator iter = this.operations.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Operation operation;
            if (i > 0) {
                p.pln();
            }
            if ((operation = (Operation)iter.next()).getStyle() == SOAPStyle.DOCUMENT) {
                this.writeDocumentOperation(p, remoteClassName, operation);
            } else {
                this.writeRpcOperation(p, remoteClassName, operation);
            }
            ++i;
        }
    }

    protected void writeRpcOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
    }

    protected void writeDocumentOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
    }

    protected void writePeekFirstBodyElementMethod(IndentingWriter p) throws IOException {
    }

    protected void writeReadFirstBodyElement(IndentingWriter p) throws IOException {
        String stateType = this.getStateType();
        p.pln("/*");
        p.pln(" *  this method deserializes the response structure in the body");
        p.pln(" */");
        p.plnI("protected void " + this.prefix + "readFirstBodyElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, " + stateType + "  state) throws Exception {");
        p.pln("int opcode = state.getRequest().getOperationCode();");
        p.plnI("switch (opcode) {");
        Iterator operationsIter = this.operations.iterator();
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            p.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            p.pln(this.prefix + "deserialize_" + operation.getUniqueName() + "(bodyReader, deserializationContext, state);");
            p.pln("break;");
            p.pO();
        }
        p.plnI("default:");
        this.writeReadFirstBodyElementDefault(p, "opcode");
        p.pO();
        p.pOln("}");
        p.pOln("}");
    }

    protected void writeReadFirstBodyElementDefault(IndentingWriter p, String state) throws IOException {
    }

    private void writeOperationDeserializeMethods(IndentingWriter p) throws IOException {
        Iterator operationsIter = this.operations.iterator();
        int i = 0;
        while (operationsIter.hasNext()) {
            if (i > 0) {
                p.pln();
            }
            Operation operation = (Operation)operationsIter.next();
            this.writeOperationDeserializeMethod(p, operation);
            ++i;
        }
    }

    private void writeOperationDeserializeMethod(IndentingWriter p, Operation operation) throws IOException {
        String stateType = this.getStateType();
        String messageName = operation.getName().getLocalPart();
        Message message = this.getMessageToDeserialize(operation);
        p.pln("/*");
        p.pln(" * This method deserializes the body of the " + messageName + " operation.");
        p.pln(" */");
        p.plnI("private void " + this.prefix + "deserialize_" + operation.getUniqueName() + "(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, " + stateType + " state) throws Exception {");
        Block bodyBlock = (Block)message.getBodyBlocks().next();
        AbstractType type = bodyBlock.getType();
        String objName = this.env.getNames().getTypeMemberName(type.getJavaType());
        SerializerWriter writer = this.writerFactory.createWriter(type);
        String serializer = writer.serializerMemberName();
        p.plnI("Object " + objName + "Obj =");
        p.plnI(serializer + ".deserialize(" + this.env.getNames().getBlockQNameName(operation, bodyBlock) + ",");
        p.pln("bodyReader, deserializationContext);");
        p.pO();
        p.pO();
        objName = this.env.getNames().getTypeMemberName(type.getJavaType()) + "Obj";
        p.pln();
        p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, bodyBlock) + ");");
        p.pln("bodyBlock.setValue(" + objName + ");");
        p.pln("state." + this.getStateGetRequestResponseString() + "().setBody(bodyBlock);");
        p.pOln("}");
    }

    protected void writeReadBodyFaultElement(IndentingWriter p) throws IOException {
    }

    protected Map writeReadHeaderElementMethod(IndentingWriter p) throws IOException {
        Message message;
        Operation operation;
        Iterator ops = this.operations.iterator();
        boolean hasHeaders = false;
        while (!hasHeaders && ops.hasNext()) {
            operation = (Operation)ops.next();
            message = operation.getRequest();
            Iterator headers = message.getHeaderBlocks();
            hasHeaders = !hasHeaders && headers.hasNext() ? true : hasHeaders;
            message = operation.getResponse();
            headers = message.getHeaderBlocks();
            boolean bl = hasHeaders = !hasHeaders && headers.hasNext() ? true : hasHeaders;
        }
        HashMap headerMap = new HashMap();
        if (!hasHeaders) {
            return headerMap;
        }
        String stateType = this.getStateType();
        p.pln("/*");
        p.pln(" * This method must deserialize headers. It dispatches to a read method based on the name");
        p.pln(" * of the header.");
        p.pln(" */");
        p.plnI("protected boolean " + this.prefix + "readHeaderElement(SOAPHeaderBlockInfo headerInfo, XMLReader headerReader, SOAPDeserializationContext deserializationContext, " + stateType + " state) throws Exception {");
        ops = this.operations.iterator();
        boolean first = true;
        while (ops.hasNext()) {
            operation = (Operation)ops.next();
            message = operation.getRequest();
            this.writeHeaderChecks(p, message.getHeaderBlocks(), first, headerMap);
            first = first && message.getHeaderBlocks().hasNext() ? false : first;
            message = operation.getResponse();
            this.writeHeaderChecks(p, message.getHeaderBlocks(), first, headerMap);
            boolean bl = first = first && message.getHeaderBlocks().hasNext() ? false : first;
        }
        p.pln();
        p.pln("return false;");
        p.pOln("}");
        return headerMap;
    }

    private void writeHeaderChecks(IndentingWriter p, Iterator headers, boolean first, Map headerMap) throws IOException {
        while (headers.hasNext()) {
            Block header = (Block)headers.next();
            if (headerMap.containsKey(header.getName())) continue;
            headerMap.put(header.getName(), header);
            if (!first) {
                p.p(" else ");
            }
            first = false;
            String qname = this.env.getNames().getBlockQNameName(null, header);
            String uname = this.env.getNames().getBlockUniqueName(null, header);
            p.plnI("if (headerInfo.getName().equals(" + qname + ")) {");
            p.pln(this.prefix + "deserialize_" + uname + "(headerInfo, headerReader, deserializationContext, state);");
            p.pln("return true;");
            p.pO("}");
        }
    }

    private void writeHeaderDeserializeMethods(IndentingWriter p, Iterator headers) throws IOException {
        int i = 0;
        while (headers.hasNext()) {
            if (i > 0) {
                p.pln();
            }
            Block header = (Block)headers.next();
            this.writeHeaderDeserializeMethod(p, header);
            ++i;
        }
    }

    private void writeHeaderDeserializeMethod(IndentingWriter p, Block header) throws IOException {
        String javaType = header.getType().getJavaType().getRealName();
        String serializer = this.writerFactory.createWriter((SOAPType)header.getType()).serializerMemberName();
        String qname = this.env.getNames().getBlockQNameName(null, header);
        String uname = this.env.getNames().getBlockUniqueName(null, header);
        String stateType = this.getStateType();
        p.pln("/*");
        p.pln(" *  This method does the actual deserialization for the header: " + header.getName().getLocalPart() + ".");
        p.pln(" */");
        p.plnI("private void " + this.prefix + "deserialize_" + uname + "(SOAPHeaderBlockInfo headerInfo, XMLReader bodyReader, SOAPDeserializationContext deserializationContext, " + stateType + " state) throws Exception {");
        p.pln("QName elementName = bodyReader.getName();");
        p.plnI("if (elementName.equals(" + qname + ")) {");
        p.plnI(javaType + " obj =");
        p.pln("(" + javaType + ")" + serializer + ".deserialize(" + qname + ", bodyReader, deserializationContext);");
        p.pOln("headerInfo.setValue(obj);");
        p.pln("state." + this.getStateGetRequestResponseString() + "().add(headerInfo);");
        p.pOlnI("} else {");
        p.pln("// the QName of the header is not what we expected and not a fault either");
        p.pln("throw new SOAPProtocolViolationException(\"soap.unexpectedHeaderBlock\", elementName.getLocalPart());");
        p.pOln("}");
        p.pOln("}");
    }

    protected void writeProcessingHookMethod(IndentingWriter p) throws IOException {
    }

    public void writeGenericMethods(IndentingWriter p) throws IOException {
    }

    private void writeGetNamespaceDeclarationsMethod(IndentingWriter p) throws IOException {
        p.pln("/*");
        p.pln(" * This method returns an array containing (prefix, nsURI) pairs.");
        p.pln(" */");
        p.plnI("protected String[] " + this.prefix + "getNamespaceDeclarations() {");
        p.pln("return myNamespace_declarations;");
        p.pOln("}");
    }

    private void writeGetUnderstoodHeadersMethod(IndentingWriter p) throws IOException {
        p.pln("/*");
        p.pln(" * This method returns an array containing the names of the headers we understand.");
        p.pln(" */");
        p.plnI("public QName[] " + this.prefix + "getUnderstoodHeaders() {");
        p.pln("return understoodHeaderNames;");
        p.pOln("}");
    }

    private void writeInitialize(IndentingWriter p) throws IOException {
        Iterator types = this.portTypes.entrySet().iterator();
        String access = this.getInitializeAccess();
        p.plnI(access + " void " + this.prefix + "initialize(InternalTypeMappingRegistry registry) throws Exception {");
        if (this.superClassHasInitialize()) {
            p.pln("super." + this.prefix + "initialize(registry);");
        }
        while (types.hasNext()) {
            Map.Entry entry = types.next();
            Block block = (Block)entry.getValue();
            AbstractType type = block.getType();
            SerializerWriter writer = this.writerFactory.createWriter(type);
            writer.initializeSerializer(p, this.env.getNames().getTypeQName(type.getName()), "registry");
        }
        Iterator operationsIter = this.operations.iterator();
        int i = 0;
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            if (operation.getFaults().hasNext()) {
                String serName = this.env.getNames().getClassMemberName(this.env.getNames().faultSerializerClassName(this.port, operation));
                p.pln("((Initializable)" + serName + ").initialize(registry);");
            }
            ++i;
        }
        p.pOln("}");
    }

    protected void writeStaticMembers(IndentingWriter p, Map headerMap) throws IOException {
        Operation operation;
        ArrayList list = new ArrayList();
        ArrayList visited = new ArrayList();
        Iterator operationsIter = this.operations.iterator();
        p.p("private static final QName " + this.prefix + "portName = ");
        GeneratorUtil.writeNewQName(p, this.port.getName());
        p.pln(";");
        int i = 0;
        while (operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            p.pln("private static final int " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + " = " + i + ";");
            ++i;
        }
        operationsIter = this.operations.iterator();
        int i2 = 0;
        while (operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
            faultSet.addAll(operation.getFaultsSet());
            Iterator faults = faultSet.iterator();
            if (faults.hasNext()) {
                this.declareStaticFaultSerializerForOperation(p, this.port, operation, this.encodeTypes, this.multiRefEncoding);
            }
            while (faults.hasNext()) {
                StubTieGeneratorBase.collectNamespaces(((Fault)faults.next()).getBlock().getType(), list, visited);
            }
            ++i2;
        }
        HashSet processedTypes = new HashSet();
        operationsIter = this.operations.iterator();
        Iterator blocks = headerMap.values().iterator();
        this.declareBlockTypes(p, null, blocks, processedTypes, list, visited);
        int i3 = 0;
        while (operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            blocks = operation.getRequest().getHeaderBlocks();
            this.declareBlockTypes(p, operation, blocks, processedTypes, list, visited);
            blocks = operation.getRequest().getBodyBlocks();
            this.declareBlockTypes(p, operation, blocks, processedTypes, list, visited);
            blocks = operation.getResponse().getHeaderBlocks();
            this.declareBlockTypes(p, operation, blocks, processedTypes, list, visited);
            blocks = operation.getResponse().getBodyBlocks();
            this.declareBlockTypes(p, operation, blocks, processedTypes, list, visited);
            ++i3;
        }
        ((AbstractCollection)list).remove("http://www.w3.org/2001/XMLSchema");
        ((AbstractCollection)list).remove("http://schemas.xmlsoap.org/soap/encoding/");
        Iterator namespaces = ((AbstractList)list).iterator();
        p.plnI("private static final String[] myNamespace_declarations =");
        p.pI(8);
        p.plnI("new String[] {");
        int j = 0;
        while (namespaces.hasNext()) {
            if (j > 0) {
                p.pln(",");
            }
            p.p("\"ns" + j + "\", ");
            p.p("\"" + (String)namespaces.next() + "\"");
            ++j;
        }
        p.pln();
        p.pOln("};");
        p.pO(8);
        p.pO();
    }

    protected abstract void writeUnderstoodHeadersMember(IndentingWriter var1, Map var2) throws IOException;

    private void declareStaticFaultSerializerForOperation(IndentingWriter p, Port port, Operation operation, boolean encodeTypesNow, boolean multiRefEncodingNow) throws IOException {
        String nillable = "NOT_NULLABLE";
        String referenceable = "REFERENCEABLE";
        String multiRef = "DONT_SERIALIZE_AS_REF";
        String encodeType = encodeTypesNow ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        String serializerClassName = this.env.getNames().faultSerializerClassName(port, operation);
        String memberName = this.env.getNames().getClassMemberName(serializerClassName);
        p.plnI("private final CombinedSerializer " + memberName + " = new ReferenceableSerializerImpl(" + multiRef + ",");
        p.pln("new " + serializerClassName + "(" + encodeType + ", " + nillable + "));");
        p.pO();
    }

    private void declareBlockTypes(IndentingWriter p, Operation operation, Iterator blocks, Set processedTypes, List list, List visited) throws IOException {
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            StubTieGeneratorBase.collectNamespaces(block.getType(), list, visited);
            if (!processedTypes.contains(this.env.getNames().getBlockQNameName(operation, block))) {
                GeneratorUtil.writeBlockQNameDeclaration(p, operation, block, this.env.getNames());
                processedTypes.add(this.env.getNames().getBlockQNameName(operation, block));
            }
            if (block.getType().isSOAPType()) {
                SOAPEncoding.writeStaticSerializer(p, (SOAPType)block.getType(), processedTypes, this.writerFactory, this.env.getNames());
                continue;
            }
            if (!block.getType().isLiteralType()) continue;
            LiteralEncoding.writeStaticSerializer(p, (LiteralType)block.getType(), processedTypes, this.writerFactory, this.env.getNames());
        }
    }

    private static void collectNamespaces(AbstractType type, List list, List visited) {
        if (visited.contains(type.getJavaType().getRealName())) {
            return;
        }
        visited.add(type.getJavaType().getRealName());
        if (type.getName().getNamespaceURI().length() > 0 && !list.contains(type.getName().getNamespaceURI())) {
            list.add(type.getName().getNamespaceURI());
        }
        if (type instanceof SOAPStructureType) {
            Iterator members = ((SOAPStructureType)type).getMembers();
            while (members.hasNext()) {
                SOAPStructureMember member = (SOAPStructureMember)members.next();
                if (member.getName().getNamespaceURI().length() > 0 && !list.contains(member.getName().getNamespaceURI())) {
                    list.add(member.getName().getNamespaceURI());
                }
                StubTieGeneratorBase.collectNamespaces(member.getType(), list, visited);
            }
        } else if (type instanceof SOAPArrayType) {
            StubTieGeneratorBase.collectNamespaces(((SOAPArrayType)type).getElementType(), list, visited);
        }
    }

    public static JavaStructureMember getJavaMember(Parameter parameter) {
        Block block = parameter.getBlock();
        JavaType type = block.getType().getJavaType();
        JavaStructureMember member = null;
        if (type instanceof JavaStructureType) {
            member = ((JavaStructureType)type).getMemberByName(parameter.getName());
            return member;
        }
        return null;
    }

    private void closeSrcFile() throws IOException {
        if (this.out != null) {
            this.out.pOln("}");
            this.out.close();
            this.out = null;
        }
    }
}

