/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.http;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.client.ClientTransport;
import com.sun.xml.rpc.client.ClientTransportException;
import com.sun.xml.rpc.client.StubPropertyConstants;
import com.sun.xml.rpc.client.http.handler.HttpURLConnection;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDBase64BinaryEncoder;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;

public class HttpClientTransport
implements ClientTransport,
StubPropertyConstants {
    public static final String HTTP_SOAPACTION_PROPERTY = "http.soap.action";
    private static final SimpleTypeEncoder base64Encoder = XSDBase64BinaryEncoder.getInstance();
    private MessageFactory _messageFactory;
    private OutputStream _logStream;
    private String _savedEndpoint;
    private String _savedCookie;
    private static final boolean _overrideDefaultHttpHandler;

    public HttpClientTransport() {
        this(null);
    }

    public HttpClientTransport(OutputStream logStream) {
        try {
            this._messageFactory = MessageFactory.newInstance();
            this._logStream = logStream;
        }
        catch (Exception e) {
            throw new ClientTransportException("http.client.cannotCreateMessageFactory");
        }
    }

    public void invoke(String endpoint, SOAPMessageContext context) throws ClientTransportException {
        try {
            String key;
            Boolean shouldMaintainSessionProperty;
            boolean shouldMaintainSession;
            if (context.getMessage().saveRequired()) {
                context.getMessage().saveChanges();
            }
            java.net.HttpURLConnection httpConnection = this.createConnection(endpoint);
            httpConnection.setDoOutput(true);
            httpConnection.setDoInput(true);
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Type", "text/xml");
            String soapAction = (String)context.getProperty(HTTP_SOAPACTION_PROPERTY);
            if (soapAction == null) {
                context.getMessage().getMimeHeaders().setHeader("SOAPAction", "");
            } else {
                context.getMessage().getMimeHeaders().setHeader("SOAPAction", "\"" + soapAction + "\"");
            }
            String credentials = (String)context.getProperty("javax.xml.rpc.security.auth.username");
            if (credentials != null) {
                credentials = credentials + ":" + (String)context.getProperty("javax.xml.rpc.security.auth.password");
                credentials = base64Encoder.objectToString(credentials.getBytes(), null);
                context.getMessage().getMimeHeaders().setHeader("Authorization", "Basic " + credentials);
            }
            boolean bl = shouldMaintainSession = (shouldMaintainSessionProperty = (Boolean)context.getProperty("javax.xml.rpc.session.maintain")) == null ? false : shouldMaintainSessionProperty;
            if (shouldMaintainSession) {
                this.addCookieIfAvailable(endpoint, httpConnection);
            }
            Iterator iter = context.getMessage().getMimeHeaders().getAllHeaders();
            while (iter.hasNext()) {
                MimeHeader header = (MimeHeader)iter.next();
                httpConnection.setRequestProperty(header.getName(), header.getValue());
            }
            OutputStream contentOut = httpConnection.getOutputStream();
            context.getMessage().writeTo(contentOut);
            contentOut.flush();
            contentOut.close();
            if (this._logStream != null) {
                String s = "******************\nRequest\n";
                this._logStream.write(s.getBytes());
                Iterator iter2 = context.getMessage().getMimeHeaders().getAllHeaders();
                while (iter2.hasNext()) {
                    MimeHeader header = (MimeHeader)iter2.next();
                    s = header.getName() + ": " + header.getValue() + "\n";
                    this._logStream.write(s.getBytes());
                }
                this._logStream.flush();
                context.getMessage().writeTo(this._logStream);
                s = "\n";
                this._logStream.write(s.getBytes());
                this._logStream.flush();
            }
            httpConnection.connect();
            boolean isFailure = false;
            try {
                if (httpConnection.getResponseCode() == 500) {
                    isFailure = true;
                } else if (httpConnection.getResponseCode() != 200) {
                    throw new ClientTransportException("http.client.cannot.connect", httpConnection.getResponseMessage());
                }
            }
            catch (IOException e) {
                if (httpConnection.getResponseCode() == 500) {
                    isFailure = true;
                }
                throw e;
            }
            MimeHeaders headers = new MimeHeaders();
            int i = 1;
            while ((key = ((URLConnection)httpConnection).getHeaderFieldKey(i)) != null) {
                String value = ((URLConnection)httpConnection).getHeaderField(i);
                try {
                    headers.addHeader(key, value);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                ++i;
            }
            if (shouldMaintainSession) {
                this.saveCookieIfPresent(endpoint, httpConnection);
            }
            InputStream contentIn = isFailure ? httpConnection.getErrorStream() : httpConnection.getInputStream();
            byte[] bytes = this.readFully(contentIn);
            int length = httpConnection.getContentLength() == -1 ? bytes.length : httpConnection.getContentLength();
            ByteInputStream in = new ByteInputStream(bytes, length);
            SOAPMessage response = this._messageFactory.createMessage(headers, (InputStream)in);
            contentIn.close();
            httpConnection = null;
            if (this._logStream != null) {
                String s = "Response\n";
                this._logStream.write(s.getBytes());
                Iterator iter3 = context.getMessage().getMimeHeaders().getAllHeaders();
                while (iter3.hasNext()) {
                    MimeHeader header = (MimeHeader)iter3.next();
                    s = header.getName() + ": " + header.getValue() + "\n";
                    this._logStream.write(s.getBytes());
                }
                this._logStream.flush();
                response.writeTo(this._logStream);
                s = "******************\n\n";
                this._logStream.write(s.getBytes());
            }
            context.setMessage(response);
        }
        catch (ClientTransportException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof Localizable) {
                throw new ClientTransportException("http.client.failed", (Localizable)((Object)e));
            }
            throw new ClientTransportException("http.client.failed", new LocalizableExceptionAdapter(e));
        }
    }

    public void invokeOneWay(String endpoint, SOAPMessageContext context) {
        try {
            if (this._logStream != null) {
                String s = "******************\nRequest\n";
                this._logStream.write(s.getBytes());
                context.getMessage().writeTo(this._logStream);
            }
            if (context.getMessage().saveRequired()) {
                context.getMessage().saveChanges();
            }
            java.net.HttpURLConnection httpConnection = this.createConnection(endpoint);
            httpConnection.setDoOutput(true);
            httpConnection.setDoInput(true);
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Type", "text/xml");
            String soapAction = (String)context.getProperty(HTTP_SOAPACTION_PROPERTY);
            if (soapAction == null) {
                context.getMessage().getMimeHeaders().setHeader("SOAPAction", "");
            } else {
                context.getMessage().getMimeHeaders().setHeader("SOAPAction", "\"" + soapAction + "\"");
            }
            String credentials = (String)context.getProperty("javax.xml.rpc.security.auth.username");
            if (credentials != null) {
                credentials = credentials + ":" + (String)context.getProperty("javax.xml.rpc.security.auth.password");
                credentials = base64Encoder.objectToString(credentials.getBytes(), null);
                context.getMessage().getMimeHeaders().setHeader("Authorization", "Basic " + credentials);
            }
            Iterator iter = context.getMessage().getMimeHeaders().getAllHeaders();
            while (iter.hasNext()) {
                MimeHeader header = (MimeHeader)iter.next();
                httpConnection.setRequestProperty(header.getName(), header.getValue());
            }
            OutputStream contentOut = httpConnection.getOutputStream();
            context.getMessage().writeTo(contentOut);
            contentOut.flush();
            contentOut.close();
        }
        catch (Exception e) {
            if (e instanceof Localizable) {
                throw new ClientTransportException("http.client.failed", (Localizable)((Object)e));
            }
            throw new ClientTransportException("http.client.failed", new LocalizableExceptionAdapter(e));
        }
    }

    private java.net.HttpURLConnection createConnection(String endpoint) throws IOException {
        if (_overrideDefaultHttpHandler) {
            return new HttpURLConnection(new URL(endpoint), null, 80);
        }
        return (java.net.HttpURLConnection)new URL(endpoint).openConnection();
    }

    private byte[] readFully(InputStream istream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        byte[] ret = bout.toByteArray();
        return ret;
    }

    private void addCookieIfAvailable(String endpoint, java.net.HttpURLConnection httpConnection) {
        if (this._savedEndpoint != null && this._savedEndpoint.equals(endpoint) && this._savedCookie != null) {
            httpConnection.setRequestProperty("Cookie", this._savedCookie);
        }
    }

    private void saveCookieIfPresent(String endpoint, java.net.HttpURLConnection httpConnection) {
        if (this._savedEndpoint == null || !this._savedEndpoint.equals(endpoint)) {
            String cookie = httpConnection.getHeaderField("Set-Cookie");
            if (cookie != null) {
                int index = cookie.indexOf(59);
                if (index > 0) {
                    cookie = cookie.substring(0, index);
                }
                this._savedEndpoint = endpoint;
                this._savedCookie = cookie;
            } else {
                this._savedEndpoint = null;
            }
        }
    }

    static {
        String version = System.getProperty("java.specification.version");
        String vmVersion = System.getProperty("java.vm.version");
        boolean override = false;
        if (version.equals("1.3") && vmVersion.startsWith("1.3") && !vmVersion.startsWith("1.3.1_")) {
            override = true;
        }
        _overrideDefaultHttpHandler = override;
    }
}

