/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.service;

import com.sun.xml.registry.common.ConnectionFactoryImpl;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXRService {
    Log log = LogFactory.getLog((String)"com.sun.xml.registry");
    private static JAXRService instance;

    private JAXRService() {
    }

    public static JAXRService getInstance() {
        if (instance == null) {
            instance = new JAXRService();
        }
        return instance;
    }

    void startService() {
        try {
            ConnectionFactoryImpl connectionFactoryImpl = new ConnectionFactoryImpl();
            InitialContext initialContext = new InitialContext();
            initialContext.rebind("javax.xml.registry.ConnectionFactory", (Object)connectionFactoryImpl);
        }
        catch (Exception exception) {
            this.log.fatal((Object)exception);
        }
    }

    void stopService() {
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.unbind("JAXRConnectionFactory");
            initialContext.close();
        }
        catch (Exception exception) {
            this.log.fatal((Object)exception);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            JAXRService.showUsage();
        }
        JAXRService jAXRService = JAXRService.getInstance();
        String string = stringArray[0];
        if (string.equals("-startService")) {
            jAXRService.startService();
        } else if (string.equals("-stopService")) {
            jAXRService.stopService();
        } else {
            JAXRService.showUsage();
        }
    }

    private static void showUsage() {
        System.err.println("Must specify -startService or -stopService");
        System.exit(-1);
    }
}

