/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.jaxm.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;

public class SerializableMessage
implements Serializable {
    private Hashtable mimeHeaders;
    private byte[] data;
    private Class factoryClass;
    private transient SOAPMessage msg;
    private transient MessageFactory factory;

    public SerializableMessage(SOAPMessage msg, Class factoryClass) {
        this.msg = msg;
        this.factoryClass = factoryClass;
        this.data = this.getMessageBytes(msg);
        this.mimeHeaders = this.getMimeHeaders(msg.getMimeHeaders());
    }

    private byte[] getMessageBytes(SOAPMessage msg) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            msg.saveChanges();
            msg.writeTo((OutputStream)baos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return baos.toByteArray();
    }

    private Hashtable getMimeHeaders(MimeHeaders mimeHeaders) {
        Hashtable<String, String> retval = new Hashtable<String, String>();
        Iterator it = mimeHeaders.getAllHeaders();
        MimeHeader hdr = null;
        String name = null;
        String value = null;
        while (it.hasNext()) {
            hdr = (MimeHeader)it.next();
            name = hdr.getName();
            value = hdr.getValue();
            retval.put(name, value);
        }
        return retval;
    }

    public MimeHeaders getMimeHeaders() {
        MimeHeaders hdrs = new MimeHeaders();
        Enumeration keys = this.mimeHeaders.keys();
        String name = null;
        String value = null;
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            value = (String)this.mimeHeaders.get(name);
            hdrs.addHeader(name, value);
        }
        return hdrs;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public MessageFactory getMessageFactory() {
        try {
            if (this.factory == null) {
                this.factory = (MessageFactory)this.factoryClass.newInstance();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.factory;
    }
}

