/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.jaxm.client.remote;

import com.sun.xml.messaging.jaxm.client.remote.ClientInfo;
import com.sun.xml.messaging.jaxm.client.remote.ProviderMetaDataImpl;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.messaging.JAXMException;
import javax.xml.messaging.ProviderMetaData;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class MessageUtil {
    public static SOAPMessage createInitMessage(MessageFactory factory, String uri, String endpoint, String callBackURI) throws SOAPException {
        SOAPMessage message = null;
        try {
            message = factory.createMessage();
            SOAPPart sp = message.getSOAPPart();
            SOAPEnvelope env = sp.getEnvelope();
            SOAPHeader hdr = env.getHeader();
            SOAPHeaderElement hdrElement = hdr.addHeaderElement(env.createName("ClientInfo", "jaxm", "http://java.sun.com/xml/jaxm"));
            hdrElement.setActor(uri);
            hdrElement.setMustUnderstand(true);
            SOAPElement elem = hdrElement.addChildElement("Method");
            elem.addTextNode("InitConnection");
            elem = hdrElement.addChildElement("Endpoint");
            elem.addTextNode(endpoint);
            elem = hdrElement.addChildElement("CallbackURL");
            elem.addTextNode(callBackURI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    public static SOAPMessage createCloseMessage(MessageFactory factory, String uri, String endpoint) throws SOAPException {
        SOAPMessage message = factory.createMessage();
        SOAPPart sp = message.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        SOAPHeader hdr = env.getHeader();
        SOAPHeaderElement hdrElement = hdr.addHeaderElement(env.createName("ClientInfo", "jaxm", "http://java.sun.com/xml/jaxm"));
        hdrElement.setActor(uri);
        hdrElement.setMustUnderstand(true);
        SOAPElement elem = hdrElement.addChildElement("Method");
        elem.addTextNode("CloseConnection");
        elem = hdrElement.addChildElement("Endpoint");
        elem.addTextNode(endpoint);
        return message;
    }

    public static SOAPMessage createMetaDataMessage(MessageFactory factory, String uri, String name, String majorVersion, String minorVersion, String[] supportedProfiles) throws SOAPException {
        SOAPMessage message = factory.createMessage();
        SOAPPart sp = message.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        SOAPHeader hdr = env.getHeader();
        SOAPHeaderElement hdrElement = hdr.addHeaderElement(env.createName("Message", "jaxm", "http://java.sun.com/xml/jaxm"));
        hdrElement.setActor(uri);
        hdrElement.setMustUnderstand(true);
        SOAPElement elem = hdrElement.addChildElement("Method");
        elem.addTextNode("MetaData");
        elem = hdrElement.addChildElement("Name");
        elem.addTextNode(name);
        elem = hdrElement.addChildElement("MajorVersion");
        elem.addTextNode(majorVersion);
        elem = hdrElement.addChildElement("MinorVersion");
        elem.addTextNode(minorVersion);
        elem = hdrElement.addChildElement("SupportedProfiles");
        int i = 0;
        while (i < supportedProfiles.length) {
            SOAPElement elem2 = elem.addChildElement("ProfileName");
            elem2.addTextNode(supportedProfiles[i]);
            ++i;
        }
        return message;
    }

    public static ProviderMetaData createMetaData(SOAPMessage message) throws SOAPException {
        SOAPPart sp = message.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        SOAPHeader header = env.getHeader();
        Iterator i = header.extractHeaderElements("http://java.sun.com/xml/jaxm/provider");
        String providerName = null;
        int majorVersion = 0;
        int minorVersion = 0;
        Object[] supportedProfiles = null;
        Name name = null;
        while (i.hasNext()) {
            SOAPHeaderElement hdrElement = (SOAPHeaderElement)i.next();
            name = hdrElement.getElementName();
            if (!name.getQualifiedName().equals("jaxm:Message")) continue;
            Iterator it = hdrElement.getChildElements();
            while (it.hasNext()) {
                SOAPElement elem = (SOAPElement)it.next();
                name = elem.getElementName();
                if (name.getLocalName().equals("Method")) {
                    if (elem.getValue().equals("MetaData")) continue;
                    throw new JAXMException("Expecting MetaData. Got " + elem.getValue());
                }
                if (name.getLocalName().equals("Name")) {
                    providerName = elem.getValue();
                    continue;
                }
                if (name.getLocalName().equals("MajorVersion")) {
                    majorVersion = Integer.parseInt(elem.getValue());
                    continue;
                }
                if (name.getLocalName().equals("MinorVersion")) {
                    minorVersion = Integer.parseInt(elem.getValue());
                    continue;
                }
                if (!name.getLocalName().equals("SupportedProfiles")) continue;
                Vector<String> v = new Vector<String>();
                Iterator it2 = elem.getChildElements();
                while (it2.hasNext()) {
                    SOAPElement elem2 = (SOAPElement)it2.next();
                    if (!elem2.getElementName().getLocalName().equals("ProfileName")) continue;
                    v.add(elem2.getValue());
                }
                supportedProfiles = new String[v.size()];
                v.copyInto(supportedProfiles);
            }
        }
        return new ProviderMetaDataImpl(providerName, majorVersion, minorVersion, (String[])supportedProfiles);
    }

    public static ClientInfo processClientInfoMessage(Iterator it) throws SOAPException {
        String endPoint = null;
        String callBackURL = null;
        String method = null;
        Name name = null;
        while (it.hasNext()) {
            SOAPElement elem = (SOAPElement)it.next();
            name = elem.getElementName();
            if (name.getLocalName().equals("Method")) {
                method = elem.getValue();
                continue;
            }
            if (name.getLocalName().equals("Endpoint")) {
                endPoint = elem.getValue();
                continue;
            }
            if (!name.getLocalName().equals("CallbackURL")) continue;
            callBackURL = elem.getValue();
        }
        return new ClientInfo(method, endPoint, callBackURL);
    }

    public boolean status(SOAPMessage message) throws SOAPException {
        return true;
    }

    public static SOAPMessage createStatusMessage(MessageFactory factory, boolean status, String uri) throws SOAPException {
        SOAPMessage message = factory.createMessage();
        SOAPPart sp = message.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        SOAPHeader hdr = env.getHeader();
        SOAPHeaderElement hdrElement = hdr.addHeaderElement(env.createName("Message", "jaxm", "http://java.sun.com/xml/jaxm"));
        hdrElement.setActor(uri);
        hdrElement.setMustUnderstand(true);
        SOAPElement elem = hdrElement.addChildElement("Method");
        elem.addTextNode("Status");
        elem = hdrElement.addChildElement("Value");
        if (status) {
            elem.addTextNode("OK");
        } else {
            elem.addTextNode("Error");
        }
        return message;
    }
}

