namespace meta {

// Implementierung von IF mit Hilfe von Member-Templates

struct SelectThen 
{ template<class Then, class Else>
  struct Result
  { typedef Then RET; };
}; 

struct SelectElse
{ template<class Then, class Else>
  struct Result
  { typedef Else RET; };
};

template<bool condition>
struct Selector
{ typedef SelectThen RET; };

template<>
struct Selector<false>
{ typedef SelectElse RET; };

template<bool condition, class Then, class Else>
struct IF
{ typedef typename Selector<condition>::RET Selector_;
  typedef typename Selector_::Result<Then,Else>::RET RET;
};



// Implementierung von CASE und SWITCH

const int DEFAULT = -32767;
const int nilValue = -32768;

struct NilCase 
{ enum {tag = nilValue};
  typedef NilCase RET;
}; 

template <int tag_,class Statement_,class Next_ = NilCase>
struct CASE
{ enum {tag = tag_};
  typedef Statement_ Statement;
  typedef Next_ Next;
}; 

template <int tag,class aCase>
struct SWITCH
{ typedef typename aCase::Next NextCase;
  enum { current_tag = aCase::tag,    
         nextTag     = NextCase::tag,
         found       = (current_tag == tag ||
                        current_tag == DEFAULT) 
       };
  typedef typename IF<(nextTag == nilValue),
                      NilCase,
                      SWITCH<tag,NextCase> 
                     >::RET NextSwitch;
  typedef typename IF<(found != 0),
                      typename aCase::Statement,  
                      typename NextSwitch::RET
                     >::RET RET;
}; 

}; // namespace meta
