/**
 * Copyright @ 2002 Lars Rwekamp (lars.roewekamp@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.wstutorial.util.soap;

import javax.xml.soap.*;
import java.util.Iterator;
import java.util.List;
import java.util.LinkedList;


/**
 * Klasse, welche einen SOAP RPC Response repraesentiert.
 *
 */

public class SOAPRPCResponse {

    /* private */

    /**
     * Return Element
     */

    private SOAPElement returnElement = null;


    /**
     * Liste alle [out] bzw. [in/out] Paramter.
     */

    private List parameterList;


    /**
     * Generiert einen SOAP RPC Response Object mit Hilfe eines Paramameters
     * vom Typ <code>SOAPMessage</code>. Die Generierung erfolgt gemaess der
     * Regeln innerhalb der SOAP 1.1. Spezification Absatz 7.1.
     *
     * @param soapMessage       Original SOAP Nachricht, welche den SOAP RPC Response beinhaltet.
     * @return SOAPRPCResponse Objekt, wenn ein SOAP RPC Response innerhalb der Nachricht enthalten ist
     *                               , null sonst
     *
     */

    public final static SOAPRPCResponse getSOAPRPCResponse(SOAPMessage soapMessage) {

        /* Rueckgabewert initialisieren */

        SOAPRPCResponse soapRpcResponse = new SOAPRPCResponse();

        /* Hilfsobjekte initialisieren */

        SOAPPart soapPart = null;
        SOAPEnvelope soapEnvelope = null;
        SOAPBody soapBody = null;
        SOAPBodyElement soapBodyElement = null;
        SOAPElement soapElement = null;

        try {


            /* SOAP Part aus SOAP Message extrahieren */

            soapPart = soapMessage.getSOAPPart();

            /* SOAP Envelope aus SOAP Part extrahieren */

            soapEnvelope = soapPart.getEnvelope();

            /* SOAP Body aus SOAP Envelope extrahieren */

            soapBody = soapEnvelope.getBody();

            /* Erstes Kind-Element extrahieren - muss laut Spezifikation die
               Responsewerte beinhalten  */

            Iterator iter = soapBody.getChildElements();

            if (iter.hasNext()) {

                /* Element extrahieren */

                Object element = iter.next();

                /* Test, ob erstes Kind-Element wirklich vom erwarteten Typ */

                if (element instanceof SOAPBodyElement) {

                    soapBodyElement = (SOAPBodyElement)element;

                    int counter = 0;

                    /* erstes Kind-Element des SOAP Body Elements extrahieren - muss
                       laut Spezifikation der Return Wert sein. */

                    /* alle weiteren Kind-Elemente des SOAP SOAP Body Elements
                       extrahieren - muessen laut Spezifikation die [out] bzw. [in/out]
                       Parameter des SOAP Aufrufes sein. */

                    Iterator bodyElementIter = soapBodyElement.getChildElements();

                    while (bodyElementIter.hasNext()) {

                        soapElement = (SOAPElement)bodyElementIter.next();

                        if (counter == 0) {

                            /* erstes Element - Return Element */

                            soapRpcResponse.setReturnElement(soapElement);

                        } else {

                            /* zweites bis Ntes Element - Parameter Element */

                            soapRpcResponse.addParameter(soapElement);
                         }
                        counter++;
                    }
                }
            }

        } catch (SOAPException e) {
            /* Exception handling */

        }

        return soapRpcResponse;

    }


    /**
     * Fuegt SOAP Element als Return Wert  hinzu.
     *
     * @return SOAP Element, welches den Return Wert beinhaltet.
     */

    public SOAPElement getReturnElement() {
        return returnElement;
    }


    /**
     * Fuegt SOAP Element als Return Wert  hinzu.
     *
     * @param returnElement SOAP Element mit Return Wert.
     */

    public void setReturnElement(SOAPElement returnElement) {
        this.returnElement = returnElement;
    }



    /**
     * Fuegt SOAP Element als Parameter zur Parameterliste hinzu.
     *
     * @param parameter  SOAP Element, welches den Parameter enthaelt.
     */

    private void addParameter(SOAPElement parameter) {

        /* Test, ob Parameterliste bereits vorhanden */

        if (this.parameterList == null) {
            this.parameterList = new LinkedList();
        }

        /* Parameter hinzufuegen */

        this.parameterList.add(parameter);
    }


}




