package de.ix.wstutorial.translator;

import javax.servlet.http.*;
import javax.servlet.*;

import javax.xml.soap.*;
import javax.xml.soap.Name;
import javax.xml.messaging.URLEndpoint;

import java.util.Iterator;
import java.io.PrintWriter;

/**
 * Sample servlet that is used for sending the message.
 *
 *
 */
public class AdvancedTranslationServlet extends HttpServlet {


//    private static Log logger = LogFactory.getLog("WSTutorial/Translator");

    private static final String NS_REQUEST_PREFIX  = "m";
    private static final String NS_REQUEST_URI     = "urn:xmethodsBabelFish";

    private static final String NS_RESPONSE_PREFIX = "namesp1";
    private static final String NS_RESPONSE_URI    = "urn:xmethodsBabelFish";
    private static final String NAME               = "BabelFishResponse";

    private static final String ENDPOINT_URL       = "http://services.xmethods.net:80/perl/soaplite.cgi";

//    private static final String ENDPOINT_URL       = "http://localhost:8070/perl/soaplite.cgi";

    private static final String SOAP_METHOD_NAME               = "BabelFish";
    private static final String SOAP_IN_PARAM_TRANSLATION_MODE = "translationmode";
    private static final String SOAP_IN_PARAM_SOURCE_DATA      = "sourcedata";
    private static final String SOAP_OUT_PARAM_RETURN          = "return";


    private static final String PARAM_TEXT_TO_TRANSLATE = "orgText";
    private static final String PARAM_FROM_LANG_TO_LANG = "fromTo";

    private static final String DEFAULT_FROM_LANG_TO_LANG = "de_en";
    private static final String DEFAULT_TEXT_TO_TRANSLATE = "Information";

    SOAPConnection connection;

    public void init(ServletConfig servletConfig) throws
            ServletException {
        super.init(servletConfig);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException {

        String faultActor  = null;
        String faultCode   = null;
        String faultString = null;

        String returnString = null;

        String outText = null;


        try {
            SOAPConnectionFactory soapConnetcionFactory = SOAPConnectionFactory.newInstance();
            connection = soapConnetcionFactory.createConnection();
        } catch (Exception e) {

        }

        try {

            // text to be translated.

            String textToTranslate = request.getParameter(PARAM_TEXT_TO_TRANSLATE);
            String translateFromTo = request.getParameter(PARAM_FROM_LANG_TO_LANG);

            if (textToTranslate == null || textToTranslate.equals("")) {
                textToTranslate = DEFAULT_TEXT_TO_TRANSLATE;
            }

            if (translateFromTo == null || translateFromTo.equals("")) {
                translateFromTo = DEFAULT_FROM_LANG_TO_LANG;
            }

            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();

            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();

            SOAPHeader header = envelope.getHeader();
            header.detachNode(); // evtl spaeter wieder raus ??

            SOAPBody body = envelope.getBody();

            Name bodyName = envelope.createName(SOAP_METHOD_NAME, NS_REQUEST_PREFIX, NS_REQUEST_URI);
            SOAPBodyElement babelFishMethod = body.addBodyElement(bodyName);

/*
            Name translationModeName = envelope.createName(SOAP_IN_PARAM_TRANSLATION_MODE);
            SOAPElement translationModeParam = babelFishMethod.addChildElement(translationModeName);
            translationModeParam.addTextNode(translateFromTo);

*/

            Name sourceDataName = envelope.createName(SOAP_IN_PARAM_SOURCE_DATA);
            SOAPElement sourceDataParam = babelFishMethod.addChildElement(sourceDataName);
            sourceDataParam.addTextNode(textToTranslate);

            // send message ....
            URLEndpoint endpoint = new URLEndpoint(ENDPOINT_URL);
            SOAPMessage soapResponse = connection.call(message, endpoint);

            SOAPPart responseSOAPPart = soapResponse.getSOAPPart();
            SOAPEnvelope responseSOAPEnvelope = responseSOAPPart.getEnvelope();
            SOAPBody responseSOAPBody = responseSOAPEnvelope.getBody();

            if (responseSOAPBody.hasFault()) {

                SOAPFault soapFault = responseSOAPBody.getFault();

                faultActor  = soapFault.getFaultActor();
                faultCode   = soapFault.getFaultCode();
                faultString = soapFault.getFaultString();

                outText = this.generateFaultOutput(faultActor, faultCode, faultString);

                /* ausgabe ... */
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                out.println(outText);
                out.flush();


            } else {

                System.out.println("NO FAULT found .... ");

                soapResponse.writeTo(response.getOutputStream());

            }

            /* ausgabe ... */
/*            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(outText);
            out.flush();


            Name responseBodyName = responseSOAPEnvelope.createName(NAME, NS_RESPONSE_PREFIX, NS_RESPONSE_URI);

//            Name responseBodyName = responseSOAPEnvelope.createName(SOAP_OUT_PARAM_RETURN);
            System.out.println("RESPONSE BODY NAME " + responseBodyName.toString());

            String translation = "unknown";

            // for test reasons ....
            Iterator iterAll = responseSOAPBody.getChildElements();

            while (iterAll.hasNext()) {
                System.out.println("Element found ...");
                SOAPBodyElement responseSOAPBodyElement = (SOAPBodyElement)iterAll.next();
                Name name   =  responseSOAPBodyElement.getElementName();
                String  a   = name.getLocalName();
                String  b   = name.getPrefix();
                String  c   = name.getQualifiedName();
                String  d   = name.getURI();

                String value  = responseSOAPBodyElement.getValue();

                System.out.println("Local Name     = " + a);
                System.out.println("Prefix         = " + b);
                System.out.println("Qualified Name = " + c);
                System.out.println("URI            = " + d);
                System.out.println("Value = " + value);
            }


/*
            Iterator iter = responseSOAPBody.getChildElements(responseBodyName);

            System.out.println("\n************** REPLY ***************\n");
            System.out.println("Iter = " + iter);


            // get response node
            if (iter != null) {

                System.out.println("Element found ...");
                Object obj = iter.next();
                String className = obj.getClass().getName();
                System.out.println("Element found ..." + className);

                SOAPBodyElement responseSOAPBodyElement = (SOAPBodyElement)obj;
                SOAPElement responseSOAPlement = null;

                // get return element
                if (responseSOAPBodyElement != null) {
                    Name responseBodyElementName = responseSOAPEnvelope.createName(SOAP_OUT_PARAM_RETURN);
                    Iterator returnIter = responseSOAPBodyElement.getChildElements(responseBodyElementName);
                    if (returnIter != null) {

                        responseSOAPlement = (SOAPElement)returnIter.next();
                        Name elementName = responseSOAPlement.getElementName();
                        String  aa   = elementName.getLocalName();
                        String  ba   = elementName.getPrefix();
                        String  ca   = elementName.getQualifiedName();
                        String  da   = elementName.getURI();
                        String  va   = responseSOAPlement.getValue();

                        System.out.println("Local Name     = " + aa);
                        System.out.println("Prefix         = " + ba);
                        System.out.println("Qualified Name = " + ca);
                        System.out.println("URI            = " + da);
                        System.out.println("Value = " + va);


                    }

                }

                translation = responseSOAPlement.getValue();
            }

            System.out.println("Uebersetzung = " + translation);
*/
  //          soapResponse.writeTo(response.getOutputStream());

            /*
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            String outText = generateHTMLOutput(textToTranslate, translation);

            out.println(outText);
            out.flush();
            */

            connection.close();

        } catch(Exception e) {
            e.printStackTrace();
            e.getMessage();
        }

    }

    private String generateFaultOutput(String faultActor, String faultCode, String faultString) {
        StringBuffer out = new StringBuffer();
        out.append("<HTML>");
        out.append("\n<BODY>");
        out.append("\nActor: ");
        out.append(faultActor);
        out.append("\nCode: ");
        out.append(faultCode);
        out.append("\nString: ");
        out.append(faultString);
        out.append("\n</BODY>");
        out.append("\n</HTML>");
        return out.toString();
    }



    private String generateHTMLOutput(String textToTranslate, String translation) {
        StringBuffer out = new StringBuffer();
        out.append("<HTML>");
        out.append("\n<BODY>");
        out.append("\nOriginal: ");
        out.append(textToTranslate);
        out.append("\n&Uuml;bersetzung: ");
        out.append(translation);
        out.append("\n</BODY>");
        out.append("\n</HTML>");
        return out.toString();
    }





}




