Imports System.Data
Imports System.Data.OleDb

Module Samples_ADONET_DataReader
  ' === Auf- und Abbau einer OLEDB-Verbindung
  Sub ADONET_Connect()
    Dim Conn As OleDbConnection
    Dim Com As OleDbCommand
    Dim DR As OleDbDataReader

    outtitle("OLEDB-Verbindung testen")

    ' --- Verbindung aufbauen
    Conn = New OleDbConnection(CONNSTRING)
    Conn.Open()

    ' --- Informationen ber die Verbindung ausgeben
    out("OLEDB Provider: " & Conn.Provider)
    out("Datenquelle: " & Conn.DataSource)
    out("Serverversion: " & Conn.ServerVersion)
    out("Datenbank: " & Conn.Database)
    out("Verbindungszeichenfolge: " & Conn.ConnectionString)
    out("Timeout-Zeit: " & Conn.ConnectionTimeout)
    out("Verbindungsstatus: " & Conn.State)
    out(Conn.ToString)

    ' --- Verbindung schlieen
    Conn.Close()

    out("Verbindung beendet!")
  End Sub

  ' === Ausgabe einer Tabelle mit Hilfe eines Datareaders
  Sub ADONET_DR1()
    Dim Conn As OleDbConnection
    Dim Com As OleDbCommand
    Dim DR As OleDbDataReader

    outtitle("Produktliste mit DataReader ausgeben")

    ' --- Verbindung aufbauen
    Conn = New OleDbConnection(CONNSTRING)
    Conn.Open()

    ' --- Befehl definieren
    Com = New OleDbCommand()
    Com.Connection = Conn
    Com.CommandText = _
    "SELECT * FROM Produkte WHERE Kategorie = 23"

    ' --- Befehl ausfhren
    DR = Com.ExecuteReader()

    ' --- Daten lesen
    While DR.Read() = True
      out(DR.Item("Name").ToString & _
      " (Produkt #" & DR.Item("ID").ToString & ") " & _
      " kostet " & _
      DR.Item("Preis").ToString & " ")

    End While

    ' --- schlieen
    DR.Close()
    Conn.Close()
  End Sub

End Module
