public aspect SpeicherungDatenbank
{
// TO DO: Introduction der Datenbank-Verbindung

// Pointcuts
	pointcut konstruktorPC(Suchmaschine sm):
		target(sm) &&
		execution(new());
		
	pointcut speichereTermPC(Suchmaschine sm,
										String term):
		target(sm) &&
		args(term) &&
		execution(public int speichereTerm(String));
		
	pointcut speichereDokumentPC(Suchmaschine sm,
										String dokument):
		target(sm) &&
		args(dokument) &&
		execution(public int speichereDokument(String));
	
	pointcut speichereGewichtPC(Suchmaschine sm,
				int dokumentID, int termID, float gewicht):
		target(sm) &&
		args(dokumentID, termID, gewicht) &&
		execution(public void speichereGewicht(int,int,		
		float));
	
	pointcut leseGewichtPC(Suchmaschine sm,
				int dokumentID, int termID):
		target(sm) &&
		args(dokumentID, termID) &&
		execution (public float leseGewicht(int, int));

// Advices
	after(Suchmaschine sm) returning():
		konstruktorPC(sm)
	{
		// TO DO: Verbindungsaufbau zur DB
	}
	
	int around(Suchmaschine sm, String term):
		speichereTermPC(sm, term)
	{
		// TO DO: Speicherung des Terms
		
		// dummy-Wert wird zurckgeliefert
		return 1;
	}
	
	int around(Suchmaschine sm, String dokument):
		speichereDokumentPC(sm, dokument)
	{
		// TO DO: Speicherung des Dokumentes
		
		// dummy-Wert wird zurckgeliefert
		return 1;
	}
	
	after(Suchmaschine sm, int dokumentID, int termID,
			float gewicht) returning():
		speichereGewichtPC(sm, dokumentID, termID,
			gewicht)
	{
		// TO DO: Gewicht speichern
	}
	
	float around(Suchmaschine sm, int dokumentID,
			int termID):
		leseGewichtPC(sm, dokumentID, termID)
	{
		// TO DO: Gewicht auslesen
		
		// dummy-Wert wird zurckgeliefert
		return 1;	
	}
}