-- Editieren Sie dieses Script entsprechend den Anweisungen
-- und fhren Sie es anschlieend im Query Analyzer des
-- SQL-Servers aus.

-- Erstellen der Datenbank
-- =======================

-- Geben Sie in der Zeile:
--   FROM disk = 'C:\backups\biblio.bak'
-- den Pfad und den Namen der Backup-Datei ein.
--
-- Ersetzen Sie in den beiden Zeilen:
--   MOVE 'biblio' TO 'c:\mssql\data\biblio.mdf',
--   MOVE 'biblio_log' TO 'c:\mssql\data\biblio_log.ldf'
-- 'c:\mssql' durch den Pfad Ihrer SQL-Server Installation.
-- Sollte Ihr Pfad z.B. 'd:\programme\sql2000' lauten, so sollten 
-- die beiden Zeilen so aussehen:
--   MOVE 'biblio' TO 'd:\programme\sql2000\data\biblio.mdf',
--   MOVE 'biblio_log' TO 'd:\programme\sql2000\data\biblio_log.ldf'

RESTORE DATABASE biblio
FROM disk = 'C:\backups\biblio.bak'
WITH 
recovery,
FILE = 1,
MOVE 'biblio' TO 'c:\mssql\data\biblio.mdf',
MOVE 'biblio_log' TO 'c:\mssql\data\biblio_log.ldf'
GO


-- Einrichten des Internet-Users
-- =============================

-- Ersetzen Sie in den folgenden Zeilen '<local_machine>' durch Ihren
-- Rechnernamen. Wenn Ihr Rechner z.B. 'goliath' heit, dann sollte
-- die folgende Zeile:
--    exec sp_grantlogin N'<local_machine>\iusr_<local_machine>'
-- in diese Zeile:
--    exec sp_grantlogin N'goliath\iusr_goliath'
-- ungewandelt werden.

use biblio
GO

-- Login
--------
if not exists (select * from master.dbo.syslogins where loginname = N'<local_machine>\iusr_<local_machine>')
	exec sp_grantlogin N'<local_machine>\iusr_<local_machine>'
GO

-- Access
---------
if not exists (select * from dbo.sysusers where name = N'<local_machine>\iusr_<local_machine>')
	EXEC sp_grantdbaccess N'<local_machine>\iusr_<local_machine>', N'<local_machine>\iusr_<local_machine>'
GO

-- Read
-------
exec sp_addrolemember N'db_datareader', N'<local_machine>\iusr_<local_machine>'
GO

-- Write
--------
exec sp_addrolemember N'db_datawriter', N'<local_machine>\iusr_<local_machine>'
GO

-- Einrichten des dbadmin-Users
-- ============================

-- Hier sind keine nderungen ntig!

use biblio
GO

-- Login
--------
if not exists (select * from master.dbo.syslogins where loginname = N'dbadmin')
BEGIN
	declare @logindb nvarchar(132), @loginlang nvarchar(132) select @logindb = N'master', @loginlang = N'Deutsch'
	if @logindb is null or not exists (select * from master.dbo.sysdatabases where name = @logindb)
		select @logindb = N'master'
	if @loginlang is null or (not exists (select * from master.dbo.syslanguages where name = @loginlang) and @loginlang <> N'us_english')
		select @loginlang = @@language
	exec sp_addlogin N'dbadmin', N'3cmdkb', @logindb, @loginlang
END
GO

-- Access
---------
if not exists (select * from dbo.sysusers where name = N'dbadmin' and uid < 16382)
	EXEC sp_grantdbaccess N'dbadmin', N'dbadmin'
GO

-- Read
-------
exec sp_addrolemember N'db_datareader', N'dbadmin'
GO

-- Write
--------
exec sp_addrolemember N'db_datawriter', N'dbadmin'
GO

