#include <iostream>
#include <exception>
using namespace std;

namespace original
{
	class IntStack
	{
		public:
			IntStack():size_(0)
			{}
			void push(const int& i)
			{
				elements_[size_++] = i;
			}
			int pop()
			{
				return elements_[--size_];
			}
			const int& size() const
			{
				return size_;
			}
			int capacity() const
			{
				return max_size_;
			}
		private:
			enum { max_size_ = 3 };
			int elements_[max_size_];
			int size_;
	};
}

namespace aspects
{
	class ReportTracing 
	{
		public:
			ReportTracing(const char* function):function_(function)
			{
				cout << "Before " << function_ << endl;
			}
			~ReportTracing()
			{
				cout << "After " << function_ << endl;
			}
		private:
			const char* function_;
	};

	class CheckingException: public exception
	{
		public:
			CheckingException(const char* msg):msg_(msg)
			{}
			const char* what() const throw()
			{	
				return msg_;
			}
		private:
			const char* msg_;
	};

	typedef original::IntStack IntStack;

	class IntStackWithTracing: public IntStack
	{
		public:
			IntStackWithTracing()
			{
				ReportTracing t("constructor");
			}
			void push(const int& i) 
			{	ReportTracing t("push");
				IntStack::push(i);
			}
			int pop() 
			{
				ReportTracing t("pop");
				return IntStack::pop();
			}
			const int& size() const
			{
				ReportTracing t("size");
				return IntStack::size();
			}
			int capacity() const
			{
				ReportTracing t("capacity");
				return IntStack::capacity();
			}
	};


	class IntStackWithChecking: public IntStack
	{
		public:
			void push(const int& i)
			{
				if (size() == capacity())
					throw CheckingException("stack overflow");
				IntStack::push(i);
			}
			int pop()
			{
				if (size() == 0)
					throw CheckingException("stack underflow");
				return IntStack::pop();
			}
	};

}

namespace composed
{
	// typedef aspects::IntStack IntStack; // "pure" IntStack
	// typedef aspects::IntStackWithChecking Stack; // IntStack with Checking
	typedef aspects::IntStackWithTracing IntStack; // Stack with Tracing
}

int main()
{
	using namespace composed;

	try
	{
		IntStack s;
		s.push(1);
		s.push(2);
		s.push(3);
		//s.push(4);
		cout << s.pop() << endl;
		cout << s.pop() << endl;
		cout << s.pop() << endl;
		//cout << s.pop() << endl;
	}
	catch (aspects::CheckingException& c)
	{
		cerr << c.what() << endl;
	}
	return 0;
}
