#include <iostream>
using namespace std;

class IntStack
{
	public:
		IntStack():size_(0)
		{}
		void push(const int& i)
		{
			elements_[size_++] = i;
		}
		int pop()
		{
			return elements_[--size_];
		}
		const int& size() const
		{
			return size_;
		}
		int capacity() const
		{
			return max_size_;
		}
	private:
		enum { max_size_ = 3 };
		int elements_[max_size_];
		int size_;
};

int main()
{
	IntStack s;
	s.push(1);
	s.push(2);
	s.push(3);
	cout << s.pop() << endl;
	cout << s.pop() << endl;
	cout << s.pop() << endl;
	return 0;
}
