<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
                xmlns="http://www.w3.org/TR/REC-html40">

  <xsl:output method="html" indent="yes"/>

  <!--REITER -->
  <xsl:template match="reiter">
    <table width="80%" align="center" border="0" cellpadding="0" cellspacing="0">
      <tr>
        <td>
          <table border="0" cellspacing="0" cellpadding="0">
            <td>
              <tr>
                <xsl:for-each select="reiteritem">
                  <td colspan="3" bgcolor="#FFCC00"><img src="/images/px.gif" height="1"/></td>
                  <td></td>
                </xsl:for-each>
              </tr>
              <tr>
                <xsl:for-each select="reiteritem">
                  <td bgcolor="#FFCC00"><img src="/images/px.gif" width="1" height="19"/></td>
                  <xsl:choose>
                    <xsl:when test="id = $selected">
                      <td height="20" nowrap="true" bgcolor="#FFCC00">
                        <font size="1">
                          <b>&#160;&#160;<xsl:value-of select="label"/>&#160;&#160;</b>
                        </font>
                      </td>
                    </xsl:when>
                    <xsl:when test="command = '' or id = $disabled">
                      <td height="20" nowrap="true" bgcolor="#FFFF66">
                        <font size="1">
                          <b>&#160;&#160;<xsl:value-of select="label"/>&#160;&#160;</b>
                        </font>
                      </td>
                    </xsl:when>
                    <xsl:otherwise>
                      <td height="20" nowrap="true" bgcolor="#FFFF66">
                        <font size="1">
                          <b>
                            &#160;&#160;
                            <a>
                              <xsl:attribute name="href">
                                <xsl:value-of select="concat($servleturl, '?command=', command)"/>
                              </xsl:attribute>
                              <xsl:value-of select="label"/>
                            </a>
                            &#160;&#160;
                          </b>
                        </font>
                      </td>
                    </xsl:otherwise>
                  </xsl:choose>

                  <td bgcolor="#FFCC00"><img src="/images/px.gif" width="1" height="19"/></td>
                  <td>&#160;</td>
                </xsl:for-each>
              </tr>
            </td>
          </table>
        </td>
      </tr>
    </table>
  </xsl:template>
  <!--REITER-->

  <!--SELECTION -->
  <xsl:template name="selection">
    <xsl:apply-templates select="select"/>
  </xsl:template>


  <xsl:template name="copytags">
    <xsl:copy>
      <xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()"/>
    </xsl:copy>
  </xsl:template>



  <xsl:template match="option">
    <xsl:copy>
      <xsl:if test="contains(../../text(), text())">
        <xsl:attribute name="selected">true</xsl:attribute>
      </xsl:if>
      <xsl:value-of select="."/>
    </xsl:copy>
  </xsl:template>


  <xsl:template match="select">
    <xsl:if test="parent::node()[@wid]">
      <xsl:copy>
        <xsl:attribute name="name">
          <xsl:value-of select="parent::node()/@wid" />
        </xsl:attribute>
        <xsl:attribute name="style">
          width:100%
        </xsl:attribute>
        <xsl:apply-templates select="option"/>
      </xsl:copy>
    </xsl:if>
  </xsl:template>




  <!-- HOTLINK -->
  <xsl:template name="hotlink">
    <xsl:param name="hotlinklabel"></xsl:param>
    <xsl:param name="hotlinkhref"></xsl:param>
    <a>
      <xsl:attribute name="href">
        <xsl:value-of select="$hotlinkhref"/>
      </xsl:attribute>
      <xsl:value-of select="$hotlinklabel"/>
    </a>
  </xsl:template>


  <!-- INPUT -->
  <xsl:template name="inputfield">
    <xsl:param name="inputfieldname"><xsl:value-of select="@wid" /></xsl:param>
    <xsl:param name="inputfieldvalue"><xsl:value-of select="." /></xsl:param>
    <xsl:param name="inputfieldlabel"><xsl:value-of select="@label" /></xsl:param>
    <!-- new -->
    <xsl:param name="inputfieldconstraint"><xsl:value-of select="@constraint" /></xsl:param>
    <xsl:param name="inputfieldmessage"><xsl:value-of select="@message" /></xsl:param>
    <!-- new -->


    <xsl:value-of select="$inputfieldlabel"/>
    <input  type="text" style="width:100%">
      <xsl:attribute name="name">
        <xsl:value-of select="$inputfieldname"/>
      </xsl:attribute>
      <xsl:attribute name="value">
        <xsl:value-of select="$inputfieldvalue"/>
      </xsl:attribute>
    </input>

    <!-- new -->
    <xsl:if test="$inputfieldconstraint">
      <input  type="hidden">
        <xsl:attribute name="name">
          <xsl:value-of select="concat('constraint_', $inputfieldname)"/>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="$inputfieldconstraint"/>
        </xsl:attribute>
      </input>
    </xsl:if>

    <font size="1"><xsl:value-of select="$inputfieldmessage"/></font>
    <!-- new -->



  </xsl:template>


  <!-- CHECKBOX -->
  <xsl:template name="checkbox">
    <xsl:param name="checkboxname"><xsl:value-of select="@wid" /></xsl:param>
    <xsl:param name="checkboxvalue"><xsl:value-of select="." /></xsl:param>
    <xsl:param name="checkboxlabel"><xsl:value-of select="@label" /></xsl:param>
    <xsl:param name="checkedvalue">true</xsl:param>
    <xsl:param name="uncheckedvalue">false</xsl:param>


    <input type="hidden">
      <xsl:attribute name="name">
        <xsl:value-of select="$checkboxname"/>
      </xsl:attribute>
      <xsl:attribute name="value">
        <xsl:value-of select="concat('webdialogcheckbox ', $uncheckedvalue)"/>
      </xsl:attribute>
    </input>

    <input type="checkbox">
      <xsl:attribute name="name">
        <xsl:value-of select="$checkboxname"/>
      </xsl:attribute>
      <xsl:attribute name="value">
        <xsl:value-of select="$checkedvalue"/>
      </xsl:attribute>
      <xsl:if test="contains($checkboxvalue, $checkedvalue)">
        <xsl:attribute name="checked">true</xsl:attribute>
      </xsl:if>
    </input>
    <xsl:value-of select="$checkboxlabel" />
  </xsl:template>

</xsl:stylesheet>
