<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
                xmlns="http://www.w3.org/TR/REC-html40">

  <xsl:import href="x4dialoglib.xsl"/>
  
  <xsl:output method="html" indent="yes"/>
  <xsl:variable name="servleturl">/servlet/ExampleServlet</xsl:variable>
  <xsl:variable name="selected">new</xsl:variable>
  <xsl:variable name="view">newview</xsl:variable>
  <xsl:variable name="disabled">edit</xsl:variable>


  <xsl:template match="/">
    <html>
      <head>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
      </head>
      <body bgcolor="white" link="blue" vlink="blue" alink="blue">
        <form method="post">
          <xsl:attribute name="action">
            <xsl:value-of select="$servleturl"/>
          </xsl:attribute>


          <!-- Name des Views aus Variable view (siehe oben) -->
          <input type="hidden" name="view">
            <xsl:attribute name="value">
              <xsl:value-of select="$view"/>
            </xsl:attribute>
          </input>

          <!-- Reiter darstellen -->
          <xsl:apply-templates select="composition/key_reiter/reiter" />

          <table width="80%" bgcolor="#FFCC00" border="0" cellspacing="0" cellpadding="0" align="center">
            <tr height="30" valign="center">
              <td colspan="2" width="100%">&#160;<input type="submit" name="command" value="Save"/>
                  &#160;<input type="submit" name="command" value="Cancel"/>
              </td>
            </tr>


            <xsl:apply-templates select="composition/key_emptyaddress/root/address"/>
            <tr height="30" valign="center">
              <td colspan="2" width="100%">&#160;<input type="submit" name="command" value="Save"/>
                  &#160;<input type="submit" name="command" value="Cancel"/>
              </td>
            </tr>
            <tr>
              <td colspan="2">
                <table width="100%" border="0">
                  <tr>
                    <td height="20" bgcolor="ffffcc">
                      <font size="1">
                        <b>
                          &#160;Message of the Day:
                          <xsl:value-of select="composition/key_message/root/message" />
                        </b>
                      </font>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
          </table>
        </form>
      </body>
    </html>
  </xsl:template>



  <xsl:template match="address">
    <tr>
      <td>
        <table width="100%" border="0">

          <xsl:for-each select="./*">
            <tr>
              <td bgcolor="ffffcc" width="50%" valign="top">
                <xsl:value-of select="@label"/>
              </td>
              <td bgcolor="ffffcc" valign="top">
                <xsl:choose>
                  <xsl:when test="@type='input'">
                    <xsl:call-template name="inputfield">
                      <xsl:with-param name="inputfieldlabel" />
                      <xsl:with-param name="inputfieldvalue">
                        <xsl:apply-templates/>
                      </xsl:with-param>
                      <xsl:with-param name="inputfieldname">
                        <xsl:value-of select="@wid"/>
                      </xsl:with-param>
                    </xsl:call-template>
                  </xsl:when>

                  <xsl:when test="@type='select'">
                    <xsl:call-template name="selection"/>
                  </xsl:when>


                  <xsl:when test="@type='checkbox'">
                    <xsl:call-template name="checkbox">
                      <xsl:with-param name="checkboxlabel" />
                    </xsl:call-template>

                  </xsl:when>
                </xsl:choose>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </td>
    </tr>
  </xsl:template>


</xsl:stylesheet>

