package bruening.x4dialog.example;

import java.util.Enumeration;
import java.util.Vector;

import java.io.PrintWriter;

import org.w3c.dom.Node;
import org.w3c.dom.Element;
import org.w3c.dom.Document;

import bruening.x4dialog.Responder;
import bruening.x4dialog.View;
import bruening.x4dialog.X4DialogPropertiesIF;
import bruening.x4dialog.XMLUtils;

public class ListViewResponder extends Responder
{

  public ListViewResponder()
  {
    super();
  }

  public void registerModels()
  {
   registerModel(application.getModel("key_address"), "key_address");
  }

  public String _executeRequestCommand()
  {
    if (getParamValue("command").equalsIgnoreCase("init") ||
        getParamValue("command").equalsIgnoreCase("list"))
      return renderView();



    if (getParamValue("command").equalsIgnoreCase("new"))
    {
      try
      {
        View view = new View();
        view.setApplication(application);
        view.setCompiledView(application.getCompiledView("NewView"));

        Document demoAnnotationEditAddress =
          XMLUtils.getXMLDocFromFile(X4DialogPropertiesIF.HOME +
                                     "demoAnnotationEditAddress.xml");
        view.registerModel(application.getModel("key_emptyaddress"),
                           demoAnnotationEditAddress,
                           "key_emptyaddress");
        view.registerModel(application.getModel("key_reiter"), null, "key_reiter");
        view.registerModel(application.getModel("key_message"), null, "key_message");

        String htmlString = view.renderView();
        view.removeModels();
        return htmlString;
      }
      catch (Exception e)
      {
        e.printStackTrace();
        return null;
      }
    }


    if (getParamValue("command").equalsIgnoreCase("edit"))
    {
      try
      {
        View view = new View();
        view.setApplication(application);
        view.setCompiledView(application.getCompiledView("EditView"));
        view.addStyleSheetParam("selectedaddress", getParamValue("wid"));

        Document demoAnnotationEditAddress =
          XMLUtils.getXMLDocFromFile(X4DialogPropertiesIF.HOME +
                                     "demoAnnotationEditAddress.xml");
        view.registerModel(application.getModel("key_address"),
                           demoAnnotationEditAddress,
                           "key_address");
        view.registerModel(application.getModel("key_reiter"), null, "key_reiter");
        view.registerModel(application.getModel("key_message"), null, "key_message");

        String htmlString = view.renderView();
        view.removeModels();
        return htmlString;
      }
      catch (Exception e)
      {
        e.printStackTrace();
        return null;
      }

    }
    if (getParamValue("command").equalsIgnoreCase("delete"))
    {
      Vector elementToDelete = new Vector();
      Vector parent = new Vector();

      Enumeration enParams = params.keys();
      while (enParams.hasMoreElements())
      {
        String paramName = (String)enParams.nextElement();
        if (paramHasPrefix(paramName, "key_address"))
        {
          if (getParamValue(paramName).equals("true"))
          {
            Element element = getNodeFromFullID(paramName);
            elementToDelete.addElement(element);
            parent.addElement(element.getParentNode());
          }
        }
      }

      Enumeration enDelete = elementToDelete.elements();
      Enumeration enParent = parent.elements();
      while (enDelete.hasMoreElements())
      {
        Node parentNode = (Node)enParent.nextElement();
        parentNode.removeChild((Element)enDelete.nextElement());
      }
      return renderView();
    }

    return null;
  }


  private String renderView()
  {
    try
    {
      View view = new View();
      view.setApplication(application);
      view.setCompiledView(application.getCompiledView("ListView"));
      view.addStyleSheetParam("disabled", "edit");
      view.registerModel(application.getModel("key_address"), null, "key_address");
      view.registerModel(application.getModel("key_reiter"), null, "key_reiter");
      view.registerModel(application.getModel("key_message"), null, "key_message");

      String htmlString = view.renderView();
      XMLUtils.printWithFormat(view.getComposite(), new PrintWriter(System.out));
      view.removeModels();
      return htmlString;
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }
}