package bruening.x4dialog.example;

import java.util.Enumeration;
import java.util.Vector;


import bruening.x4dialog.Responder;
import bruening.x4dialog.View;
import bruening.x4dialog.ConstraintManager;
import bruening.x4dialog.ConstraintIF;
import bruening.x4dialog.X4DialogPropertiesIF;
import bruening.x4dialog.XMLUtils;

import org.w3c.dom.Element;
import org.w3c.dom.Document;
import org.w3c.dom.Text;


public class EditViewResponder extends Responder
{

  public EditViewResponder()
  {
    super();
  }

  public void registerModels()
  {
    registerModel(application.getModel("key_address"), "key_address");
  }

  public String _executeRequestCommand()
  {
    Vector rejectedParamName = new Vector();
    Vector rejectedMessage = new Vector();
    Vector rejectedPrefix = new Vector();

    if (getParamValue("command").equalsIgnoreCase("save"))
    {
      boolean constraintViolation = false;

      Enumeration enParams = params.keys();
      while (enParams.hasMoreElements())
      {
        String param = (String)enParams.nextElement();

        if (paramHasPrefix(param, "key_address"))
        {

          if (this.getParamValue("constraint_" + param) != null)
          {
            ConstraintManager constraintManager = new ConstraintManager();

            // liefert eine Enumeration von Constraint-Obkjekten,
            // die dem Input-Feld zugeordnet sind.
            Enumeration enConstraints =
              constraintManager.getConstraints(getParamValue("constraint_" + param));

            // alle Contraints auswerten fuer ein Input-Feld auswerten

            boolean violationFound = false;
            while (enConstraints.hasMoreElements() && !violationFound)
            {
              ConstraintIF constraint = (ConstraintIF)enConstraints.nextElement();
              constraint.setValue(this.getParamValue(param));

              if (!constraint.checkConstraint())
              {

                System.out.println("++++" + constraint.getMessage());
                constraintViolation = true;
                violationFound = true;
                rejectedMessage.addElement(constraint.getMessage());
                rejectedParamName.addElement(this.getParamWithoutPrefix(param));
                rejectedPrefix.addElement(this.getParamPrefix(param));
              }
            }
          }


          Element element = getNodeFromFullID(param);
          element.removeChild(element.getFirstChild());
          Document doc = element.getOwnerDocument();
          Text paramText = doc.createTextNode(getParamValue(param));
          element.appendChild(paramText);
        }
      }

      if (constraintViolation)
      {
        return renderEditView(this.getParamValue("selectedaddress"),
                              rejectedParamName.elements(),
                              rejectedMessage.elements(),
                              rejectedPrefix.elements());
      }
      else
      {
        return renderView();
      }
    }

    if (getParamValue("command").equalsIgnoreCase("cancel"))
    {
      return renderView();
    }

    return null;
  }

  private String renderView()
  {
    try
    {
      View view = new View();
      view.setApplication(application);
      view.setCompiledView(application.getCompiledView("ListView"));
      view.addStyleSheetParam("disabled", "edit");
      view.registerModel(application.getModel("key_address"), null, "key_address");
      view.registerModel(application.getModel("key_reiter"), null, "key_reiter");
      view.registerModel(application.getModel("key_message"), null, "key_message");

      String htmlString = view.renderView();
      view.removeModels();
      return htmlString;
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }


  private String renderEditView(String id,
                                Enumeration enRejectedParamName,
                                Enumeration enRejectedMessage,
                                Enumeration enRejectedPrefix)
  {
    try
    {
      View view = new View();
      view.setApplication(application);
      view.setCompiledView(application.getCompiledView("EditView"));
      view.addStyleSheetParam("selectedaddress", id);

      Document demoAnnotationEditAddress =
        XMLUtils.getXMLDocFromFile(X4DialogPropertiesIF.HOME +
                                   "demoAnnotationEditAddress.xml");
      view.registerModel(application.getModel("key_address"),
                         demoAnnotationEditAddress,
                         "key_address");
      view.registerModel(application.getModel("key_reiter"), null, "key_reiter");
      view.registerModel(application.getModel("key_message"), null, "key_message");

      while (enRejectedParamName.hasMoreElements())
      {
        String paramName = (String)enRejectedParamName.nextElement();
        String message = (String)enRejectedMessage.nextElement();
        String prefix = (String)enRejectedPrefix.nextElement();
        view.registerRejectedMessage(paramName, prefix, message);
      }

      String htmlString = view.renderView();
      view.removeModels();
      return htmlString;
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }


}