package bruening.x4dialog;

import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Writer;
import java.io.Reader;

import java.util.StringTokenizer;
import java.util.NoSuchElementException;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.PrefixResolverDefault;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.apache.xalan.xpath.XPathProcessorImpl;

import org.apache.xerces.parsers.DOMParser;

import org.xml.sax.SAXException;
import org.xml.sax.InputSource;

import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xml.serialize.OutputFormat;

public class XMLUtils
{

  public static Document getXMLDocFromReader(Reader reader)
  {
    try
    {
      InputSource inputSource = new InputSource(reader);
      DOMParser parser = new DOMParser();
      parser.parse(inputSource);
      return parser.getDocument();
    }
    catch (IOException e)
    {
      e.printStackTrace();
      return null;
    }
    catch (SAXException e)
    {
      e.printStackTrace();
      return null;
    }

  }

  // laedt xml-File fname als Document
  public static Document getXMLDocFromFile(String fname)
  {
    try
    {
      return getXMLDocFromReader(new FileReader(fname));
    }
    catch (FileNotFoundException e)
    {
      e.printStackTrace();
      return null;
    }
  }




  public static Node cloneNode(Document factory, Node node)
  {
    return factory.importNode(node, true);
  }


  public static Element getNode(String path, Document doc)
  {
    try
    {
      return (Element)XPathAPI.selectSingleNode(doc, path);
    }
    catch (SAXException e)
    {
      return null;
    }

  }

  private static boolean isEqual(Element a, String tokenTagName, String tokenIndex)
  {
    if (a.getTagName().equals(tokenTagName))
    {
      return a.getAttribute("tokenindex").equals(tokenIndex);
    }
    return false;
  }

  // fuegt in Document doc einen Knoten mit dem Pfad path ein. Fehlende Knoten
  // werden automatisch eingefgt. Der Text-Wert des Knotens ist value.
  public static Document addPathToDoc(String path, String value, Document doc)
  {
    StringTokenizer st = new StringTokenizer(path, "/");
    NodeList nodeList = doc.getChildNodes();
    Element referenceElement = null;

    while (st.hasMoreTokens())
    {
      String token = st.nextToken();
      String tokenTagName = token.substring(0, token.indexOf('['));
      String tokenIndex = token.substring(token.indexOf('[') + 1, token.indexOf(']'));
      if (nodeList.getLength() == 0)
      {
        Element element = doc.createElement(tokenTagName);
        element.setAttribute("tokenindex", tokenIndex);
        if (doc.getDocumentElement() == null)
        {
          doc.appendChild(element);
        }
        else
        {
          referenceElement.appendChild(element);
        }


        referenceElement = element;
        nodeList = referenceElement.getChildNodes();
        if (!st.hasMoreTokens())
        {
          Document tempDoc = element.getOwnerDocument();
          Text valueText = tempDoc.createTextNode(value);
          element.appendChild(valueText);
        }
      }
      else
      {
        boolean found = false;
        for (int i = 0; i < nodeList.getLength(); i++)
        {
          if (isEqual((Element)nodeList.item(i), tokenTagName, tokenIndex))
          {
            found = true;
            referenceElement = (Element)nodeList.item(i);
            nodeList = referenceElement.getChildNodes();
            break;
          }
        }
        if (!found)
        {
          Element element = doc.createElement(tokenTagName);
          element.setAttribute("tokenindex", tokenIndex);
          referenceElement.appendChild(element);
          referenceElement = element;
          nodeList = referenceElement.getChildNodes();
          if (!st.hasMoreTokens())
          {
            Document tempDoc = element.getOwnerDocument();
            Text valueText = tempDoc.createTextNode(value);
            element.appendChild(valueText);
          }
        }
      }
    }
    return doc;
  }

  public static int getImmediateElementChildrenCount(Element element)
  {
    NodeList nodeList = element.getChildNodes();
    int count = nodeList.getLength();
    if (count == 0)
      return count;

    int elementCount = 0;
    for (int i = 0; i < count; i++)
    {
      if (nodeList.item(i).getNodeType() == Node.ELEMENT_NODE)
      {
        elementCount++;
      }
    }
    return elementCount;
  }

  public static void printWithFormat(Document doc, Writer writer)
  {
    OutputFormat outputFormat = new OutputFormat("XML", "ISO-8859-1", true);

    outputFormat.setIndent(2);
    outputFormat.setIndenting(true);
    outputFormat.setPreserveSpace(true);

    DOMSerializer serializer = new XMLSerializer(writer, outputFormat);
    try
    {
      serializer.serialize(doc);
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }


  }

}
