package bruening.x4dialog;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Enumeration;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

abstract public class X4DialogServlet extends HttpServlet
{
  protected X4DialogApplicationIF application = null;

  public void init(ServletConfig config) throws ServletException
  {
    super.init(config);
    registerApplication();
  }

  abstract public void registerApplication();

  public X4DialogServlet()
  {
    super();
  }


  public void doPost(HttpServletRequest request, HttpServletResponse response)
         throws ServletException, IOException
  {
    doGet(request, response);
  }

  public void doGet(HttpServletRequest request, HttpServletResponse response)
         throws ServletException, IOException
  {
    response.setContentType("text/html");
    response.setHeader("pragma", "nocache");
    PrintWriter out = response.getWriter();

    ResponderIF responder =
      application.getResponder(request.getParameter("view"), request.getParameter("command"));
    responder.setApplication(application);
    responder.registerModels();
    responder.setParams(getParams(request));
    out.println(responder.executeRequestCommand());
    out.close();
  }

  private Hashtable getParams(HttpServletRequest request)
  {
    Hashtable params = new Hashtable();
    Enumeration enParameterNames = request.getParameterNames();

    while (enParameterNames.hasMoreElements())
    {
      String parameterName = (String)enParameterNames.nextElement();
      String parameterValue = request.getParameter(parameterName);
      params.put(parameterName, parameterValue);
    }
    return params;
  }
}
