package bruening.x4dialog;

import java.util.Hashtable;
import java.util.Enumeration;
import java.io.PrintWriter;

import org.w3c.dom.Document;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.StylesheetRoot;
import org.xml.sax.SAXException;



public abstract class X4DialogApplication implements X4DialogApplicationIF
{
  protected Hashtable hashtableX4DialogModel = new Hashtable();
  protected Hashtable hashtableCompiledView = new Hashtable();

  public void registerModel(X4DialogModelIF webDialogModel, String id)
  {
    hashtableX4DialogModel.put(id, webDialogModel);

    XMLUtils.printWithFormat(webDialogModel.getXMLRepresentation(), new PrintWriter(System.out));
  }

  public X4DialogModelIF getModel(String id)
  {
    return (X4DialogModelIF)hashtableX4DialogModel.get(id);
  }

  public void registerView(String viewName, String id)
  {
    try
    {
      XSLTProcessor processor = XSLTProcessorFactory.getProcessor();
      StylesheetRoot stylesheetRoot = processor.processStylesheet(X4DialogPropertiesIF.HOME + viewName + ".xsl");
      hashtableCompiledView.put(id, stylesheetRoot);
    }
    catch (SAXException e)
    {
      e.printStackTrace();
    }

  }


  public StylesheetRoot getCompiledView(String id)
  {
    return (StylesheetRoot)hashtableCompiledView.get(id);
  }

  abstract public ResponderIF getResponder(String view, String command);

}
