package bruening.x4dialog;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import java.util.StringTokenizer;
import java.util.Enumeration;
import java.util.Vector;


public class Tester
{
  public Enumeration getConstraints(String value)
  {
    Vector constraints = new Vector();
    StringTokenizer st = new StringTokenizer(value, ";");
    while (st.hasMoreTokens())
    {
      String token = st.nextToken();
      int bracketLeft = token.indexOf("(");
      String constraintClassName = token.substring(0, bracketLeft);
      try
      {
        Class constraintClass = Class.forName("bruening.x4dialog." + constraintClassName);
        Object constraint = constraintClass.newInstance();
        constraints.addElement(constraint);

        int bracketRight = token.indexOf(")");
        String parameters = token.substring(bracketLeft + 1, bracketRight);
        StringTokenizer stParameters = new StringTokenizer(parameters, ",");
        while (stParameters.hasMoreTokens())
        {
          //constraint.addParameter(stParameters.nextToken());
        }
      }
      catch (ClassNotFoundException e)
      {
        e.printStackTrace();
      }
      catch (IllegalAccessException e)
      {
        e.printStackTrace();
      }
      catch (InstantiationException e)
      {
        e.printStackTrace();
      }
    }
    return constraints.elements();
  }

  public Tester()
  {
    Enumeration enConstraints = getConstraints("NumericConstraint(); NumericRangeConstraint(100, 200)");
    while (enConstraints.hasMoreElements())
    {
      ConstraintIF constraint = (ConstraintIF)enConstraints.nextElement();
      System.out.println(constraint.getConstraintName());
      constraint.printParameters();
    }

    /*
    StringTokenizer st = new StringTokenizer(test, ";");
    while (st.hasMoreTokens())
    {
      String token = st.nextToken();
      int bracketLeft = token.indexOf("(");
      int bracketRight = token.indexOf(")");
      String parameter = token.substring(bracketLeft + 1, bracketRight);
      if (parameter == null)
      {
        System.out.println("null");
      }
      System.out.println(parameter);
    }
    */





  }


  public static void main(String[] args)
  {
    Tester tester = new Tester();

  }
}
