package bruening.x4dialog;

import org.w3c.dom.Node;
import org.w3c.dom.Element;

import java.util.Enumeration;

public class PathVisitor extends NOOPVisitor
{
  private String prefix;

  public PathVisitor()
  {
    super();
  }

  public PathVisitor(String prefix)
  {
    this();
    this.prefix = prefix;
  }


  private int getElementPosition(Element element)
  {
    int position = 1;
    try
    {
      Node prevSibling = element.getPreviousSibling();

      while (prevSibling != null)
      {
        if (prevSibling.getNodeType() == Node.ELEMENT_NODE)
        {
          if (prevSibling.getNodeName().equals(element.getNodeName()))
            position++;
        }
        prevSibling = prevSibling.getPreviousSibling();
      }
      return position;
    }
    catch (Exception e)
    { e.printStackTrace();
      return 0; }
  }

  public void visitElementPost(Element element)
  {
    String path = element.getAttribute("wid");
    String anPath = element.getAttribute("anid");
    Node parent = element.getParentNode();
    while (parent instanceof Element)
    {
      Element parentElement = (Element)parent;
      path = parentElement.getAttribute("wid") + "/" + path;
      anPath = parentElement.getAttribute("anid") + "/" + anPath;
      parent = parent.getParentNode();
    }
    element.setAttribute("wid", prefix + ":" + path);
    element.setAttribute("anid", anPath);
  }

  public void visitElementPre(Element element)
  {
    String path = element.getTagName();
    element.setAttribute("anid", path);
    path = path + "[" + getElementPosition(element) + "]";
    element.setAttribute("wid", path);
  }

}
