package bruening.x4dialog;

public class NumericRangeConstraint extends AbstractConstraint
{
  private int leftRange;
  private int rightRange;
  private static final String PARAMETER_ERROR =
    "NumericRangeConstraint: Fehler bei den Parametern von NumericRangeConstraint.";

  private String message;

  public NumericRangeConstraint()
  {
    super();
  }

  public boolean checkConstraint()
  {
    if (!checkParameters())
    {
      return false;
    }

    try
    {
      int intValue = Integer.parseInt(value);
      boolean result = (leftRange <= intValue) && (intValue <= rightRange);
      if (!result)
      {
        message =
          "NumericRangeConstraint: Der eingegebene Wert mu einen Wert zwischen " + leftRange + " und " + rightRange + " haben.";
      }
      return result;
    }
    catch (NumberFormatException e)
    {
      message = "NumericRangeConstraint: Der eingegebene Wert mu numerisch sein.";
      return false;
    }
  }

  private boolean checkParameters()
  {
    message = PARAMETER_ERROR;
    try
    {
      if (parameters.size() == 2)
      {
        leftRange = Integer.parseInt((String)parameters.elementAt(0));
        rightRange = Integer.parseInt((String)parameters.elementAt(1));
        message = "";
        return true;
      }
      return false;
    }
    catch (NumberFormatException e)
    {
      return false;
    }
  }

  public String getMessage()
  {
    return message;
  }


}