package de.ix.jspTutorial.taglib;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.*;

import java.lang.reflect.Method ;

/**
 * Simple If Condition statement
 *
 * example:
 * <xmp>
 * <%@ taglib uri="/ixtaglib" prefix="jsptut" %>
 * ...
 *  <jsptut:if expr="true">
 *    Hello here is the body
 *  </jsptut:if>
 *  <% boolean bool= false ; %>
 *  <jsptut:if expr="<%=bool%>">
 *    Never see it
 *  </jsptut:if>
 * ...
 * </xmp>

 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>)
 * @version $Id:$
 */

public class IfTag extends TagSupport
{
   /**
    * Source-Version
    */
   public static String vcid = "$Id:$";

   /**
    * Current Expression Value
    */
   private boolean myExpression ;
   
    /** 
     * set default Expression to true
     */
   public IfTag()
    {
        myExpression = true;
    }

    /** 
     * Check the Expression, is true include body
     * @exception JspTagException
     */
    public int doStartTag()
        throws JspTagException
    {
        return myExpression ? EVAL_BODY_INCLUDE : SKIP_BODY;
    }
    
    /** 
     * Reset to Default
     */
    public void release()
    {
        myExpression = true;
        super.release();
    }

    /** 
     * Set Boolean expression Value.
     * @param aExpr set Expression
     */
    public void setExpr(Boolean aExpr)
    {
        setExpr(aExpr.booleanValue());
    }

    /** 
     * Set String expression Value and convert.
     * @param aExpr set Expression
     * @see IfTag#parseBoolean(String,boolean)
     */
    public void setExpr(String aExpr)
    {
        setExpr(parseBoolean(aExpr, true));
    }

    /** 
     * Set boolean expression Value.
     * @param aExpr set Expression
     */
    public void setExpr(boolean aExpr)
    {
        myExpression = aExpr;
    }

    /**
     * Is the String aExpr <I>true</I> or <I>yes</I> 
     * @param aExpr
     * @param aDefault
     */
    protected boolean parseBoolean(String aExpr, boolean aDefault)
    {
        if(aExpr != null)
            return aExpr.equalsIgnoreCase("yes") || aExpr.equalsIgnoreCase("true");
        else
            return aDefault;
    }

} // end of class

//
//
// History:
//
// $Log:$
//