/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.model;
import java.util.HashSet;
import java.util.Iterator;
import de.ix.jspTutorial.database.* ;

/**
 * This class to represents a base pizza withou any
 * ingredients.
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
 * @version $Id:$
 */
public class Pizza implements I_DatabaseObject {

  /**
    * version of the source
    */
  public static String vcid = "$Id:$";

  /**
   * pizzas name
   */
  private String name;

  /**
   * base price of the pizza
   */
   private double basePrice;

  /**
   * unique id
   */
   private long   id;

  /**
   * pizzas size
   */
   private String size;

   /**
    * Constructor for an empty pizza.
    */
   public Pizza() {
      this.id = -1;
      this.name = null;
      this.size = "";
      this.basePrice = 0.00;
   }

   /**
    * Constructor for a real base pizza
    *
    *
    * @param id unique id of the base pizza
    * @param name name of the base pizza
    * @param size size of the  badse pizza
    * @param basePrice price of the base pizza
    *
    */
   public Pizza(long id, String name, String size, double basePrice) {
      this.id = id;
      this.name = name;
      this.size = size;
      this.basePrice = basePrice;
   }

   /**
    * Method to create a generic object
    *
    * @return a DatabaseGenericObject
    *
    * @see de.ix.jspTutorial.database.DatabaseGenericModifier#create(I_DatabaseGenericObject,String)
    */
   public DatabaseGenericObject getGenericObject() {
     DatabaseGenericObject theDbPizza=
	     new DatabaseGenericObject() ;
     theDbPizza.putValue("id",new Long(getId())) ;
     theDbPizza.putValue("name",getName());
     theDbPizza.putValue("baseprice",new Double(getBasePrice())) ;
     theDbPizza.putValue("size",getSize()) ;
     return theDbPizza ;
   }

    /**
    * Setter method for the attribute <code>name</code>
    *
    * @param newName new value for the attribute name
    *
    * @see Pizza#getName()
    */
   public void setName(String newName) {
      name = newName;
   }

 /**
    * Getter method for the attribute <code>name</code>
    *
    * @return current value of the attribute name
    *
    * @see Pizza#setName(String)
    */
   public String getName() {
      return name;
   }

    /**
    * Setter method for the attribute <code>basePrice</code>
    *
    * @param newbasePrice new value for the attribute basePrice
    *
    * @see Pizza#getBasePrice()
    */
   public void setBasePrice(double newBasePrice) {
      basePrice = newBasePrice;
   }

 /**
    * Getter method for the attribute <code>basePrice</code>
    *
    * @return current value of the attribute basePrice
    *
    * @see Pizza#setBasePrice(double)
    */
   public double getBasePrice() {
      return basePrice;
   }

   /**
    * Setter method for the attribute <code>id</code>
    *
    * @param newId new value for the attribute id
    *
    * @see Pizza#getId()
    */
   public void setId(long newId) {
      id = newId;
   }

 /**
    * Getter method for the attribute <code>id</code>
    *
    * @return current value of the attribute id
    *
    * @see Pizza#setId(long)
    */
   public long getId() {
      return id;
   }

  /**
    * Setter method for the attribute <code>size</code>
    *
    * @param newSize new value for the attribute size
    *
    * @see Pizza#getSize()
    */
   public void setSize(String newSize) {
      size = newSize;
   }

  /**
    * Getter method for the attribute <code>size</code>
    *
    * @return current value of the attribute size
    *
    * @see Pizza#setSize(String)
    */
   public String getSize() {
      return size;
   }

   /**
    * Build a string out of the order attributes.
    *
    * @return String representation of the pizza
    *
    */
   public String toString() {
      return "Id: " + id + "  Name: " + name + "  Size: " + size
             + "  Base Price: " + basePrice;
   }
}

//
// History
//
// $Log:$
//
//