/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de)
 * 
 * Source is only for non commercial and coaching usage.
 * 
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.database ;

import java.util.Enumeration;

/** 
 * Beschreibung eines Generischen Objekts fr die Speicherung von Objekten
 * in die Datenbank.
 *
 * @see de.ix.jspTutorial.database.DatabaseGenericModifier
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>)
 * @version $Id:$
 */
public interface I_DatabaseGenericObject extends I_DatabaseObject
{
  /**
   *
   * Version
   */
  public static String vcid ="$Id:$";
  
	
	/** Diese Methode registriert den angegeben Wert unter dem
      angegebenen Schlssel im internen Dictionary. Ist der Schlssel
      bereits vorhanden, so wird der alte Wert berschrieben.

      @param aValue der Wert
      @param aKey der Schlssel
  */
  public void putValue(String aKey, Object aValue);



  /** Diese Methode liefert den assoziierten Wert des angegebenen
      Schlssel aus dem internen Dictionary. Ist der Schlssel
      nicht vorhanden, so wird null zurueckgegeben.

      @param aKey der Schlssel
      @return aValue der Wert
  */
  public Object getValue(String aKey);



  /** Diese Methode entfernt den angegebenen Schlssel aus dem
      internen Dictionary.

      @param aKey der Schlssel 
  */
  public void remove(String aKey);



  /** Diese Methode reicht die Methode keys an die zugrundeliegende
      Hashtable weiter.

      @see java.util.Hashtable

      @return Enumeration der Keys 
  */
  public Enumeration keys();



  /** Diese Methode reicht die Methode elements an die zugrundeliegende
      Hashtable weiter.

      @see java.util.Hashtable

      @return Enumeration der Keys 
  */
  public Enumeration elements();

  /**
   * Lsche alle Werte und Attribute
   */
  public void clear() ;

  /** Diese Methode reicht die Methode size an die zugrundeliegende
      Hashtable weiter.

      @see java.util.Hashtable

      @return Anzahl der Key/value-Paare
  */
  public int size();



  /** Diese Methode erzeugt eine Kopie des Objektes.

      @return Kopie des Objektes
  */
  public Object clone();

} // end of interface


//
// History:
//
// $Log:$
//
//
