/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Cache;
import db.Database;
import db.RowRangeCache;
import db.Table;
import db.Transaction;
import db.idbDataOutputStream;
import db.indexTable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;

public abstract class Column {
    static int totalLookups;
    static final int PRIMARY_KEY = 1;
    static final int UNIQUE = 2;
    static final int NOT_NULL = 3;
    static final int DEFAULT = 4;
    static final int AUTOINCREMENT = 5;
    static final int ALLOW_ACCIDENTAL_NULLS = 6;
    static final int AUTO_BASE = 7;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_DATE = 5;
    public static final int TYPE_CURRENCY = 6;
    public static final int TYPE_FLOAT = 7;
    public static final int TYPE_DOUBLE = 8;
    public static final int TYPE_INDEX = 9;
    public static final int TYPE_BLOB = 10;
    public static final int TYPE_CHAR1 = 11;
    static final int ORDER_NONE = 0;
    static final int ORDER_ASC = 1;
    static final int ORDER_DESC = 2;
    public static final int[] SQL_TYPES;
    public static final String[] typeNames;
    Table cTable;
    String colName;
    int recOffset;
    int colLength;
    boolean isPrimaryKey;
    boolean unique;
    boolean notNull;
    boolean readOnly;
    Object defaultValue;
    Object lastValueInserted;
    int type;
    Database dbase;
    Object nullObj;
    Integer colID;
    boolean requiresRecovery;
    boolean allowAccidentalNulls;
    Cache rowCache;
    int order;
    long headerPosn;
    Table underlyingTable;

    int getNullHash() {
        return this.getHash(this.nullObj);
    }

    void setBooleanProperty(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.isPrimaryKey = bl;
                break;
            }
            case 2: {
                this.unique = bl;
                break;
            }
            case 3: {
                this.notNull = bl;
                break;
            }
            case 6: {
                this.allowAccidentalNulls = bl;
                break;
            }
        }
    }

    void setProperty(int n, Object object) {
        switch (n) {
            case 4: {
                this.defaultValue = object;
                break;
            }
        }
    }

    void setOffset(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Column offset must be positive");
        }
        this.recOffset = n;
    }

    public String getName() {
        return this.colName;
    }

    public int getType() {
        return this.type;
    }

    public boolean allowsNull() {
        return !this.notNull;
    }

    int getOffset() {
        return this.recOffset;
    }

    Table getTable() {
        return this.cTable;
    }

    public int getLength() {
        return this.colLength;
    }

    public int getRowCount() {
        return this.cTable.getRowCount();
    }

    Object getDefault() {
        return this.defaultValue;
    }

    public boolean inPrimaryKey() {
        return this.isPrimaryKey;
    }

    Object getNull() {
        return this.nullObj;
    }

    public abstract boolean isAutoIncrement();

    public int getColID() {
        return this.colID;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    void setUnderlyingTable(Table table) {
        this.underlyingTable = table;
    }

    Table getUnderlyingTable() {
        return this.underlyingTable;
    }

    public abstract boolean isNull(Object var1);

    public abstract String toString(Object var1);

    abstract void writeObject(idbDataOutputStream var1, Object var2, Transaction var3, int var4) throws IOException;

    abstract Object toObject(Object var1);

    abstract boolean numeric();

    abstract boolean hashPreservesOrder();

    abstract int getHash(Object var1);

    abstract boolean compare(int var1, Object var2, int var3, boolean var4) throws SQLException;

    void read(RandomAccessFile randomAccessFile) throws IOException {
        this.headerPosn = randomAccessFile.getFilePointer();
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
        this.headerPosn = randomAccessFile.getFilePointer();
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(this.headerPosn);
    }

    boolean hasOwnIndex() {
        return this.cTable.getIndex(this) != null;
    }

    boolean RUcalled(Object object, Object object2) {
        String string;
        if (object != null && !(string = object instanceof Table ? ((Table)object).getTableName() : (String)object).equalsIgnoreCase(this.cTable.getTableName())) {
            return false;
        }
        String string2 = object2 instanceof Column ? ((Column)object2).getName() : (String)object2;
        return string2.equalsIgnoreCase(this.colName);
    }

    void setCacheCondition(int n, int n2, boolean bl) {
        if (this.cTable.rndFile == null && !bl) {
            return;
        }
        this.rowCache.setCacheCondition(n, n2);
    }

    void setCacheCondition(int n, int n2) {
        this.setCacheCondition(n, n2, false);
    }

    Object getByRow(int n) throws SQLException {
        if (n == 0) {
            return this.colName + '(' + typeNames[this.type] + ')';
        }
        ++totalLookups;
        Object object = this.rowCache.get(n);
        if (object != null) {
            return object;
        }
        try {
            this.cTable.readRow(n, this.recOffset);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
        }
        return null;
    }

    void recover(Object object) {
    }

    void onDelete(RandomAccessFile randomAccessFile, int n, Transaction transaction) throws SQLException {
    }

    void onClose() {
        if (this.rowCache == null) {
            return;
        }
        this.rowCache = null;
    }

    void onDrop() {
    }

    int getRowByValue(Object object, int n) throws SQLException {
        int n2 = 1;
        int n3 = this.cTable.rowCount;
        indexTable indexTable2 = this.cTable.getIndex(this);
        if (indexTable2 != null) {
            int[] nArray = indexTable2.lookupValue(object, true);
            if (nArray == null) {
                return 0;
            }
            n2 = nArray[0];
            n3 = nArray[1];
        }
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = n4;
            if (indexTable2 != null) {
                n5 = indexTable2.getRowByRow(n4);
            }
            if (n5 != n && this.compare(n5, object, 1, false) && !this.cTable.rowDeleted(n5)) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public Object getLastValueInserted() {
        return this.lastValueInserted;
    }

    final void setRow(idbDataOutputStream idbDataOutputStream2, int n, Object object, Transaction transaction) throws SQLException {
        int n2;
        Object object2;
        if (object instanceof String && ((String)(object2 = (String)object)).equalsIgnoreCase("NULL")) {
            object = null;
        }
        if ((object2 = this.toObject(object)) == null) {
            throw new SQLException("Column " + this.colName + " cannot accept value " + object);
        }
        if (object2 == this.nullObj && this.notNull) {
            throw new SQLException(this.colName + " column does not allow nulls", "XOPEN?");
        }
        if (this.unique && object2 != this.nullObj && (n2 = this.getRowByValue(object2, n)) != 0) {
            throw new SQLException("Value " + object2 + " already exists in column " + this.cTable.getTableName() + "." + this.colName);
        }
        try {
            if (idbDataOutputStream2 != null) {
                this.writeObject(idbDataOutputStream2, object2, transaction, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
        }
        this.rowCache.add(object2, n);
        this.lastValueInserted = object2;
    }

    Column(Table table, String string, int n) throws SQLException {
        this.colName = new String(string);
        this.dbase = table.dbase;
        this.colLength = n;
        table.addColumn(this);
        this.cTable = table;
        this.rowCache = new RowRangeCache();
        this.rowCache.setRange(this, 1, 0);
        if (this.cTable.rndFile == null) {
            this.rowCache.setCacheCondition(2, 100);
        }
    }

    static {
        SQL_TYPES = new int[]{0, -6, 4, 12, -5, 91, -5, 6, 6, 1111, -4};
        typeNames = new String[]{"", "BYTE", "INTEGER", "CHAR", "LONG", "DATE", "CURRENCY", "FLOAT", "DOUBLE", "INDEX", "BINARY"};
    }
}

