/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.IMAPProtocol;
import java.io.IOException;
import java.util.Vector;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;

public class IMAPStore
extends Store
implements ConnectionListener,
ResponseHandler {
    private String name = "imap";
    private IMAPProtocol protocol;
    private int blksize = 16384;
    private int port = 143;
    private String host;
    private String user;
    private String password;
    private Vector folders;

    public IMAPStore(Session session, URLName uRLName) {
        super(session, uRLName);
        String string;
        if (uRLName != null) {
            this.name = uRLName.getProtocol();
        }
        if ((string = session.getProperty("mail." + this.name + ".partialfetch")) != null && string.equalsIgnoreCase("false")) {
            this.blksize = -1;
            return;
        }
        string = session.getProperty("mail." + this.name + ".fetchsize");
        if (string != null) {
            this.blksize = Integer.parseInt(string);
        }
    }

    protected synchronized boolean protocolConnect(String string, int n, String string2, String string3) throws MessagingException {
        if (string == null || string3 == null || string2 == null) {
            return false;
        }
        if (n != -1) {
            this.port = n;
        } else {
            String string4 = this.session.getProperty("mail." + this.name + ".port");
            if (string4 != null) {
                this.port = Integer.parseInt(string4);
            }
        }
        if (this.port == -1) {
            this.port = 143;
        }
        try {
            if (this.protocol == null) {
                this.protocol = new IMAPProtocol(this.name, string, this.port, this.session.getDebug(), this.session.getProperties());
            }
            this.login(this.protocol, string2, string3);
            this.protocol.addResponseHandler(this);
            this.host = string;
            this.user = string2;
            this.password = string3;
            return true;
        }
        catch (CommandFailedException commandFailedException) {
            return false;
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        catch (IOException iOException) {
            throw new MessagingException(iOException.getMessage(), iOException);
        }
    }

    private void login(IMAPProtocol iMAPProtocol, String string, String string2) throws ProtocolException {
        if (iMAPProtocol.hasCapability("AUTH-LOGIN") || iMAPProtocol.hasCapability("AUTH=LOGIN")) {
            iMAPProtocol.authlogin(string, string2);
            return;
        }
        iMAPProtocol.login(string, string2);
    }

    IMAPProtocol getProtocol(IMAPFolder iMAPFolder) throws MessagingException {
        IMAPProtocol iMAPProtocol = null;
        try {
            iMAPProtocol = new IMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getProperties());
            this.login(iMAPProtocol, this.user, this.password);
        }
        catch (Exception exception) {
            if (iMAPProtocol != null) {
                try {
                    iMAPProtocol.logout();
                }
                catch (Exception exception2) {}
            }
            iMAPProtocol = null;
        }
        if (iMAPProtocol == null) {
            throw new MessagingException("connection failure");
        }
        if (iMAPFolder != null) {
            IMAPStore iMAPStore = this;
            synchronized (iMAPStore) {
                if (this.folders == null) {
                    this.folders = new Vector();
                }
                this.folders.addElement(iMAPFolder);
                iMAPFolder.addConnectionListener(this);
            }
        }
        return iMAPProtocol;
    }

    IMAPProtocol getProtocol() {
        return this.protocol;
    }

    int getFetchBlockSize() {
        return this.blksize;
    }

    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            this.protocol.noop();
        }
        catch (ProtocolException protocolException) {}
        return super.isConnected();
    }

    public void close() throws MessagingException {
        if (!super.isConnected()) {
            return;
        }
        try {
            this.protocol.logout();
            return;
        }
        catch (ProtocolException protocolException) {
            this.cleanup();
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private synchronized void cleanup() {
        if (this.folders != null) {
            int n = 0;
            int n2 = this.folders.size();
            while (n < n2) {
                IMAPFolder iMAPFolder = (IMAPFolder)this.folders.elementAt(n);
                iMAPFolder.removeConnectionListener(this);
                try {
                    iMAPFolder.close(false);
                }
                catch (MessagingException messagingException) {}
                ++n;
            }
            this.folders = null;
        }
        this.protocol = null;
        try {
            super.close();
            return;
        }
        catch (MessagingException messagingException) {
            return;
        }
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    public Folder getFolder(String string) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(string, '\uffff', this);
    }

    public Folder getFolder(URLName uRLName) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(uRLName.getFile(), '\uffff', this);
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    public void opened(ConnectionEvent connectionEvent) {
    }

    public void disconnected(ConnectionEvent connectionEvent) {
    }

    public synchronized void closed(ConnectionEvent connectionEvent) {
        if (this.folders != null) {
            this.folders.removeElement(connectionEvent.getSource());
        }
    }

    public void handleResponse(Response response) {
        if (response.isBYE()) {
            if (super.isConnected()) {
                this.cleanup();
            }
            return;
        }
        if (response.isOK()) {
            String string = response.toString();
            if (string.indexOf("ALERT") != -1) {
                this.notifyStoreListeners(1, string);
                return;
            }
            this.notifyStoreListeners(2, string);
        }
    }
}

